/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.rbsprintf;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.format.FormatEncoding;
import org.truffleruby.core.format.FormatRootNode;
import org.truffleruby.core.format.rbsprintf.RBSprintfConfig;
import org.truffleruby.core.format.rbsprintf.RBSprintfSimpleParser;
import org.truffleruby.core.format.rbsprintf.RBSprintfSimpleTreeBuilder;
import org.truffleruby.core.string.StringSupport;

public final class RBSprintfCompiler {
    private final RubyLanguage language;
    private final Node currentNode;
    private static int SIGN = 16;

    public RBSprintfCompiler(RubyLanguage language, Node currentNode) {
        this.language = language;
        this.currentNode = currentNode;
    }

    @CompilerDirectives.TruffleBoundary
    public RootCallTarget compile(AbstractTruffleString formatTString, RubyEncoding formatEncoding, Object stringReader) {
        InternalByteArray byteArray = formatTString.getInternalByteArrayUncached(formatEncoding.tencoding);
        RBSprintfSimpleParser parser = new RBSprintfSimpleParser(StringSupport.bytesToChars(byteArray), false);
        List<RBSprintfConfig> configs = parser.parse();
        RBSprintfSimpleTreeBuilder builder = new RBSprintfSimpleTreeBuilder(configs, stringReader, formatEncoding);
        return new FormatRootNode(this.language, this.currentNode.getEncapsulatingSourceSection(), new FormatEncoding(formatEncoding), builder.getNode()).getCallTarget();
    }

    public RubyArray typeList(AbstractTruffleString formatTString, RubyEncoding formatEncoding, TruffleString.GetInternalByteArrayNode byteArrayNode, RubyContext context, RubyLanguage language) {
        InternalByteArray byteArray = byteArrayNode.execute(formatTString, formatEncoding.tencoding);
        RBSprintfSimpleParser parser = new RBSprintfSimpleParser(StringSupport.bytesToChars(byteArray), false);
        List<RBSprintfConfig> configs = parser.parse();
        int[] types = new int[3 * configs.size()];
        int pos = 0;
        int highWaterMark = -1;
        for (RBSprintfConfig config : configs) {
            int typeInt;
            if (config.isLiteral()) continue;
            if (config.isPrecisionStar()) {
                types[pos] = RBSprintfConfig.FormatArgumentType.INT.ordinal();
                highWaterMark = Math.max(highWaterMark, pos);
                ++pos;
            } else if (config.isPrecisionArg()) {
                types[config.getPrecision().intValue()] = RBSprintfConfig.FormatArgumentType.INT.ordinal();
                highWaterMark = Math.max(highWaterMark, config.getPrecision());
            }
            if (config.isWidthStar()) {
                types[pos] = RBSprintfConfig.FormatArgumentType.INT.ordinal();
                highWaterMark = Math.max(highWaterMark, pos);
                ++pos;
            } else if (config.isArgWidth()) {
                types[config.getWidth().intValue()] = RBSprintfConfig.FormatArgumentType.INT.ordinal();
                highWaterMark = Math.max(highWaterMark, config.getWidth());
            }
            if (config.getFormatType() == RBSprintfConfig.FormatType.RUBY_VALUE) {
                typeInt = RBSprintfConfig.FormatArgumentType.VALUE.ordinal();
            } else {
                switch (config.getFormat()) {
                    case 'd': 
                    case 'i': {
                        typeInt = config.getFormatArgumentType().ordinal() | SIGN;
                        break;
                    }
                    default: {
                        typeInt = config.getFormatArgumentType().ordinal();
                    }
                }
            }
            int typePos = config.getAbsoluteArgumentIndex() != null ? config.getAbsoluteArgumentIndex() - 1 : pos++;
            types[typePos] = typeInt;
            highWaterMark = Math.max(highWaterMark, typePos);
        }
        return new RubyArray(context.getCoreLibrary().arrayClass, language.arrayShape, types, highWaterMark + 1);
    }
}

