/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.read.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.read.SourceNode;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;

@NodeChild(value="source", type=SourceNode.class)
public abstract class ReadHashValueNode
extends FormatNode {
    private final Object key;
    @Node.Child
    private DispatchNode fetchNode;
    private final ConditionProfile oneHashProfile = ConditionProfile.create();

    public ReadHashValueNode(Object key) {
        this.key = key;
    }

    @Specialization
    Object read(VirtualFrame frame, Object[] source) {
        if (this.oneHashProfile.profile(source.length != 1 || !RubyGuards.isRubyHash(source[0]))) {
            throw new RaiseException(this.getContext(), this.getContext().getCoreExceptions().argumentErrorOneHashRequired(this));
        }
        RubyHash hash = (RubyHash)source[0];
        if (this.fetchNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.fetchNode = (DispatchNode)this.insert(DispatchNode.create());
        }
        return this.fetchNode.call((Object)hash, "fetch", this.key);
    }
}

