/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.read.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.convert.ToLongNode;
import org.truffleruby.core.format.convert.ToLongNodeGen;
import org.truffleruby.core.format.read.SourceNode;
import org.truffleruby.core.numeric.RubyBignum;

@NodeChild(value="source", type=SourceNode.class)
@ImportStatic(value={ArrayGuards.class})
public abstract class ReadLongOrBigIntegerNode
extends FormatNode {
    @Node.Child
    private ToLongNode toLongNode;
    private final ConditionProfile bignumProfile = ConditionProfile.create();

    @Specialization(limit="storageStrategyLimit()")
    Object read(VirtualFrame frame, Object source, @CachedLibrary(value="source") ArrayStoreLibrary sources) {
        Object value = sources.read(source, this.advanceSourcePosition(frame));
        if (this.bignumProfile.profile(value instanceof RubyBignum)) {
            return value;
        }
        if (this.toLongNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toLongNode = (ToLongNode)this.insert(ToLongNodeGen.create(false, null));
        }
        return this.toLongNode.executeToLong(frame, value);
    }
}

