/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.read.bytes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.read.SourceNode;

@NodeChild(value="source", type=SourceNode.class)
public abstract class ReadUUStringNode
extends FormatNode {
    @Node.Child
    private TruffleString.FromByteArrayNode fromByteArrayNode = TruffleString.FromByteArrayNode.create();

    @Specialization
    Object encode(VirtualFrame frame, byte[] source) {
        ByteBuffer encode = this.wrapByteBuffer(frame, source);
        byte[] bytes = this.read(encode);
        this.setSourcePosition(frame, encode.position());
        return this.createString(this.fromByteArrayNode, bytes, Encodings.BINARY);
    }

    @CompilerDirectives.TruffleBoundary
    private byte[] read(ByteBuffer encode) {
        int length = encode.remaining() * 3 / 4;
        byte[] lElem = new byte[length];
        int index = 0;
        int s = 0;
        int total = 0;
        if (length > 0) {
            s = encode.get();
        }
        while (encode.hasRemaining() && s > 32 && s < 97) {
            byte[] hunk = new byte[3];
            int len = s - 32 & 0x3F;
            s = ReadUUStringNode.safeGet(encode);
            if ((total += len) > length) {
                len -= total - length;
                total = length;
            }
            while (len > 0) {
                int d;
                int c;
                int b;
                int a;
                int mlen = Math.min(len, 3);
                if (encode.hasRemaining() && s >= 32) {
                    a = s - 32 & 0x3F;
                    s = ReadUUStringNode.safeGet(encode);
                } else {
                    a = 0;
                }
                if (encode.hasRemaining() && s >= 32) {
                    b = s - 32 & 0x3F;
                    s = ReadUUStringNode.safeGet(encode);
                } else {
                    b = 0;
                }
                if (encode.hasRemaining() && s >= 32) {
                    c = s - 32 & 0x3F;
                    s = ReadUUStringNode.safeGet(encode);
                } else {
                    c = 0;
                }
                if (encode.hasRemaining() && s >= 32) {
                    d = s - 32 & 0x3F;
                    s = ReadUUStringNode.safeGet(encode);
                } else {
                    d = 0;
                }
                hunk[0] = (byte)((a << 2 | b >> 4) & 0xFF);
                hunk[1] = (byte)((b << 4 | c >> 2) & 0xFF);
                hunk[2] = (byte)((c << 6 | d) & 0xFF);
                for (int i = 0; i < mlen; ++i) {
                    lElem[index++] = hunk[i];
                }
                len -= mlen;
            }
            if (s == 13) {
                s = ReadUUStringNode.safeGet(encode);
                continue;
            }
            if (s == 10) {
                s = ReadUUStringNode.safeGet(encode);
                continue;
            }
            if (!encode.hasRemaining()) continue;
            if (ReadUUStringNode.safeGet(encode) == 10) {
                ReadUUStringNode.safeGet(encode);
                continue;
            }
            if (!encode.hasRemaining()) continue;
            encode.position(encode.position() - 1);
        }
        return Arrays.copyOfRange(lElem, 0, index);
    }
}

