/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.write.bytes;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.ByteOrder;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.language.library.RubyStringLibrary;

@NodeChild(value="value")
public abstract class WriteBitStringNode
extends FormatNode {
    private final ByteOrder byteOrder;
    private final boolean star;
    private final int length;

    public WriteBitStringNode(ByteOrder byteOrder, boolean star, int length) {
        this.byteOrder = byteOrder;
        this.star = star;
        this.length = length;
    }

    @Specialization(guards={"libString.isRubyString(string)"}, limit="1")
    Object write(VirtualFrame frame, Object string, @Cached RubyStringLibrary libString, @Cached TruffleString.GetInternalByteArrayNode byteArrayNode) {
        AbstractTruffleString tstring = libString.getTString(string);
        TruffleString.Encoding encoding = libString.getTEncoding(string);
        return this.write(frame, byteArrayNode.execute(tstring, encoding));
    }

    protected Object write(VirtualFrame frame, InternalByteArray byteArray) {
        int byteLength = byteArray.getLength();
        int occurrences = this.star ? byteLength : this.length;
        int currentByte = 0;
        int padLength = 0;
        if (occurrences > byteLength) {
            padLength = (occurrences - byteLength) / 2 + (occurrences + byteLength) % 2;
            occurrences = byteLength;
        }
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            int i = 0;
            while (i < occurrences) {
                if ((byteArray.get(i++) & 1) != 0) {
                    currentByte |= 0x80;
                }
                if ((i & 7) == 0) {
                    this.writeByte(frame, (byte)(currentByte & 0xFF));
                    currentByte = 0;
                    continue;
                }
                currentByte >>= 1;
            }
            if ((occurrences & 7) != 0) {
                this.writeByte(frame, (byte)((currentByte >>= 7 - (occurrences & 7)) & 0xFF));
            }
        } else {
            int i = 0;
            while (i < occurrences) {
                currentByte |= byteArray.get(i++) & 1;
                if ((i & 7) == 0) {
                    this.writeByte(frame, (byte)(currentByte & 0xFF));
                    currentByte = 0;
                    continue;
                }
                currentByte <<= 1;
            }
            if ((occurrences & 7) != 0) {
                this.writeByte(frame, (byte)((currentByte <<= 7 - (occurrences & 7)) & 0xFF));
            }
        }
        this.writeNullBytes(frame, padLength);
        return null;
    }
}

