/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.format.write.bytes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.collections.ByteArrayBuilder;
import org.truffleruby.core.format.FormatNode;
import org.truffleruby.core.format.write.bytes.EncodeUM;
import org.truffleruby.language.library.RubyStringLibrary;

@NodeChild(value="value")
public abstract class WriteUUStringNode
extends FormatNode {
    private final int length;
    private final boolean ignoreStar;

    public WriteUUStringNode(int length, boolean ignoreStar) {
        this.length = length;
        this.ignoreStar = ignoreStar;
    }

    @Specialization(guards={"libString.isRubyString(string)"}, limit="1")
    Object write(VirtualFrame frame, Object string, @Cached RubyStringLibrary libString, @Cached TruffleString.GetInternalByteArrayNode byteArrayNode) {
        AbstractTruffleString tstring = libString.getTString(string);
        TruffleString.Encoding encoding = libString.getTEncoding(string);
        this.writeBytes(frame, this.encode(byteArrayNode.execute(tstring, encoding)));
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    private byte[] encode(InternalByteArray byteArray) {
        ByteArrayBuilder output = new ByteArrayBuilder();
        EncodeUM.encodeUM(byteArray, this.length, this.ignoreStar, 'u', output);
        return output.getBytes();
    }

    protected boolean isEmpty(byte[] bytes) {
        return bytes.length == 0;
    }
}

