/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.hash;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.core.hash.library.BucketsHashStore;
import org.truffleruby.core.hash.library.EmptyHashStore;
import org.truffleruby.core.hash.library.PackedHashStoreLibraryFactory;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;

public abstract class HashLiteralNode
extends RubyContextSourceNode {
    @Node.Children
    protected final RubyNode[] keyValues;

    protected HashLiteralNode(RubyNode[] keyValues) {
        assert (keyValues.length % 2 == 0);
        this.keyValues = keyValues;
    }

    public static HashLiteralNode create(RubyNode[] keyValues) {
        if (keyValues.length == 0) {
            return new EmptyHashStore.EmptyHashLiteralNode();
        }
        if (keyValues.length <= 6) {
            return PackedHashStoreLibraryFactory.SmallHashLiteralNodeGen.create(keyValues);
        }
        return new BucketsHashStore.GenericHashLiteralNode(keyValues);
    }

    @Override
    @ExplodeLoop
    public void doExecuteVoid(VirtualFrame frame) {
        for (RubyNode child : this.keyValues) {
            child.doExecuteVoid(frame);
        }
    }
}

