/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.hash;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Split;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.collections.PEBiFunction;
import org.truffleruby.core.array.ArrayBuilderNode;
import org.truffleruby.core.array.ArrayHelpers;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.hash.HashGuards;
import org.truffleruby.core.hash.HashNodesFactory;
import org.truffleruby.core.hash.HashingNodes;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.core.hash.library.EmptyHashStore;
import org.truffleruby.core.hash.library.HashStoreLibrary;
import org.truffleruby.core.hash.library.PackedHashStoreLibrary;
import org.truffleruby.core.kernel.KernelNodes;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.language.Nil;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.objects.AllocationTracing;
import org.truffleruby.language.objects.shared.PropagateSharingNode;
import org.truffleruby.language.yield.CallBlockNode;

@CoreModule(value="Hash", isClass=true)
public abstract class HashNodes {

    @CoreMethod(names={"rehash"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class RehashNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isCompareByIdentity(hash)"})
        RubyHash rehashIdentity(RubyHash hash) {
            return hash;
        }

        @Specialization(guards={"!isCompareByIdentity(hash)"}, limit="hashStrategyLimit()")
        RubyHash rehashNotIdentity(RubyHash hash, @CachedLibrary(value="hash.store") HashStoreLibrary hashes) {
            hashes.rehash(hash.store, hash);
            return hash;
        }
    }

    @CoreMethod(names={"size", "length"})
    @ImportStatic(value={HashGuards.class})
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int size(RubyHash hash) {
            return hash.size;
        }
    }

    @CoreMethod(names={"shift"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class ShiftNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"hash.empty()"})
        Nil shiftEmpty(RubyHash hash, @Cached DispatchNode callDefault) {
            return nil;
        }

        @Specialization(guards={"!hash.empty()"}, limit="hashStrategyLimit()")
        RubyArray shift(RubyHash hash, @CachedLibrary(value="hash.store") HashStoreLibrary hashes) {
            return hashes.shift(hash.store, hash);
        }
    }

    @CoreMethod(names={"default="}, required=1, raiseIfFrozenSelf=true)
    public static abstract class SetDefaultValueNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object setDefault(RubyHash hash, Object defaultValue, @Cached PropagateSharingNode propagateSharingNode) {
            propagateSharingNode.execute(this, hash, defaultValue);
            hash.defaultValue = defaultValue;
            hash.defaultBlock = nil;
            return defaultValue;
        }
    }

    @Primitive(name="hash_set_default_proc")
    public static abstract class SetDefaultProcNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyProc setDefaultProc(RubyHash hash, RubyProc defaultProc, @Cached PropagateSharingNode propagateSharingNode) {
            propagateSharingNode.execute(this, hash, defaultProc);
            hash.defaultValue = nil;
            hash.defaultBlock = defaultProc;
            return defaultProc;
        }

        @Specialization
        Object setDefaultProc(RubyHash hash, Nil defaultProc) {
            hash.defaultValue = nil;
            hash.defaultBlock = nil;
            return nil;
        }
    }

    @Primitive(name="hash_collect")
    @ImportStatic(value={HashGuards.class})
    public static abstract class MapNode
    extends PrimitiveArrayArgumentsNode
    implements HashStoreLibrary.EachEntryCallback {
        @Node.Child
        HashStoreLibrary.YieldPairNode yieldPair = HashStoreLibrary.YieldPairNode.create();
        @Node.Child
        ArrayBuilderNode arrayBuilder = ArrayBuilderNode.create();

        @Specialization(limit="hashStrategyLimit()")
        RubyArray map(RubyHash hash, RubyProc block, @CachedLibrary(value="hash.store") HashStoreLibrary hashes) {
            int size = hash.size;
            ArrayBuilderNode.BuilderState state = this.arrayBuilder.start(size);
            hashes.eachEntrySafe(hash.store, hash, this, new MapState(state, block));
            return ArrayHelpers.createArray(this.getContext(), this.getLanguage(), this.arrayBuilder.finish(state, size), size);
        }

        @Override
        public void accept(int index, Object key, Object value, Object state) {
            MapState mapState = (MapState)state;
            this.arrayBuilder.appendValue(mapState.builderState, index, this.yieldPair.execute(mapState.block, key, value));
        }

        private static final class MapState {
            final ArrayBuilderNode.BuilderState builderState;
            final RubyProc block;

            private MapState(ArrayBuilderNode.BuilderState builderState, RubyProc block) {
                this.builderState = builderState;
                this.block = block;
            }
        }
    }

    @CoreMethod(names={"initialize_copy", "replace"}, required=1, raiseIfFrozenSelf=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        @NeverDefault
        public static InitializeCopyNode create() {
            return HashNodesFactory.InitializeCopyNodeFactory.create(null);
        }

        public abstract RubyHash execute(RubyHash var1, RubyHash var2);

        @Specialization(limit="hashStrategyLimit()")
        RubyHash replace(RubyHash self, RubyHash from, @CachedLibrary(value="from.store") HashStoreLibrary hashes) {
            hashes.replace(from.store, from, self);
            return self;
        }

        @Specialization(guards={"!isRubyHash(from)"})
        RubyHash replaceCoerce(RubyHash self, Object from, @Cached DispatchNode coerceNode, @Cached InitializeCopyNode initializeCopy) {
            Object otherHash = coerceNode.call(this.coreLibrary().truffleTypeModule, "coerce_to", from, (Object)this.coreLibrary().hashClass, (Object)this.coreSymbols().TO_HASH);
            return initializeCopy.execute(self, (RubyHash)otherHash);
        }
    }

    @CoreMethod(names={"initialize"}, needsBlock=true, optional=1, raiseIfFrozenSelf=true, split=Split.HEURISTIC)
    @ImportStatic(value={HashGuards.class})
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyHash initialize(RubyHash hash, NotProvided defaultValue, Nil block) {
            assert (HashStoreLibrary.verify(hash));
            hash.defaultValue = nil;
            hash.defaultBlock = nil;
            return hash;
        }

        @Specialization
        RubyHash initialize(RubyHash hash, NotProvided defaultValue, RubyProc block, @Cached.Shared @Cached PropagateSharingNode propagateSharingNode) {
            assert (HashStoreLibrary.verify(hash));
            hash.defaultValue = nil;
            propagateSharingNode.execute(this, hash, block);
            hash.defaultBlock = block;
            return hash;
        }

        @Specialization(guards={"wasProvided(defaultValue)"})
        RubyHash initialize(RubyHash hash, Object defaultValue, Nil block, @Cached.Shared @Cached PropagateSharingNode propagateSharingNode) {
            assert (HashStoreLibrary.verify(hash));
            propagateSharingNode.execute(this, hash, defaultValue);
            hash.defaultValue = defaultValue;
            hash.defaultBlock = nil;
            return hash;
        }

        @Specialization(guards={"wasProvided(defaultValue)"})
        Object initialize(RubyHash hash, Object defaultValue, RubyProc block) {
            throw new RaiseException(this.getContext(), this.coreExceptions().argumentError("wrong number of arguments (1 for 0)", this));
        }
    }

    @CoreMethod(names={"empty?"})
    @ImportStatic(value={HashGuards.class})
    public static abstract class EmptyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isEmpty(RubyHash hash) {
            return hash.empty();
        }
    }

    @CoreMethod(names={"each", "each_pair"}, needsBlock=true, enumeratorSize="size")
    @ImportStatic(value={HashGuards.class})
    public static abstract class EachNode
    extends CoreMethodArrayArgumentsNode
    implements HashStoreLibrary.EachEntryCallback {
        @Node.Child
        CallBlockNode callBlockNode = CallBlockNode.create();

        @Specialization(limit="hashStrategyLimit()")
        RubyHash each(RubyHash hash, RubyProc block, @CachedLibrary(value="hash.store") HashStoreLibrary hashes) {
            hashes.eachEntrySafe(hash.store, hash, this, block);
            return hash;
        }

        @Override
        public void accept(int index, Object key, Object value, Object state) {
            this.callBlockNode.yield((RubyProc)state, this.createArray(new Object[]{key, value}));
        }
    }

    @CoreMethod(names={"delete"}, required=1, needsBlock=true, raiseIfFrozenSelf=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class DeleteNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="hashStrategyLimit()")
        Object delete(RubyHash hash, Object key, Object maybeBlock, @CachedLibrary(value="hash.store") HashStoreLibrary hashes, @Cached CallBlockNode yieldNode, @Cached @Cached.Shared InlinedConditionProfile hasValue, @Cached @Cached.Shared InlinedConditionProfile hasBlock) {
            Object value = hashes.delete(hash.store, hash, key);
            if (hasValue.profile((Node)this, value != null)) {
                return value;
            }
            if (hasBlock.profile((Node)this, maybeBlock != nil)) {
                return yieldNode.yield((RubyProc)maybeBlock, key);
            }
            return nil;
        }
    }

    @Primitive(name="hash_default_value")
    public static abstract class DefaultValueNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object defaultValue(RubyHash hash) {
            return hash.defaultValue;
        }
    }

    @CoreMethod(names={"default_proc"})
    public static abstract class DefaultProcNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object defaultProc(RubyHash hash) {
            return hash.defaultBlock;
        }
    }

    @CoreMethod(names={"compare_by_identity?"})
    public static abstract class IsCompareByIdentityNode
    extends CoreMethodArrayArgumentsNode {
        private final ConditionProfile profile = ConditionProfile.create();

        @Specialization
        boolean compareByIdentity(RubyHash hash) {
            return this.profile.profile(hash.compareByIdentity);
        }
    }

    @CoreMethod(names={"compare_by_identity"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class CompareByIdentityNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"!isCompareByIdentity(hash)"}, limit="hashStrategyLimit()")
        RubyHash compareByIdentity(RubyHash hash, @CachedLibrary(value="hash.store") HashStoreLibrary hashes) {
            hash.compareByIdentity = true;
            hashes.rehash(hash.store, hash);
            return hash;
        }

        @Specialization(guards={"isCompareByIdentity(hash)"})
        RubyHash alreadyCompareByIdentity(RubyHash hash) {
            return hash;
        }
    }

    @CoreMethod(names={"clear"}, raiseIfFrozenSelf=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class ClearNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="hashStrategyLimit()")
        RubyHash clear(RubyHash hash, @CachedLibrary(value="hash.store") HashStoreLibrary hashes) {
            hashes.clear(hash.store, hash);
            return hash;
        }
    }

    @Primitive(name="hash_store")
    @ImportStatic(value={HashGuards.class})
    public static abstract class StoreNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(limit="hashStrategyLimit()")
        Object set(RubyHash hash, Object key, Object value, @CachedLibrary(value="hash.store") HashStoreLibrary hashes) {
            hashes.set(hash.store, hash, key, value, hash.compareByIdentity);
            return value;
        }
    }

    @CoreMethod(names={"[]="}, required=2, raiseIfFrozenSelf=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class SetIndexNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="hashStrategyLimit()")
        Object set(RubyHash hash, Object key, Object value, @CachedLibrary(value="hash.store") HashStoreLibrary hashes) {
            hashes.set(hash.store, hash, key, value, hash.compareByIdentity);
            return value;
        }
    }

    @Primitive(name="hash_get_or_undefined")
    @ImportStatic(value={HashGuards.class})
    public static abstract class GetOrUndefinedNode
    extends PrimitiveArrayArgumentsNode
    implements PEBiFunction {
        @Specialization(limit="hashStrategyLimit()")
        Object getOrUndefined(RubyHash hash, Object key, @CachedLibrary(value="hash.store") HashStoreLibrary hashes) {
            return hashes.lookupOrDefault(hash.store, null, hash, key, this);
        }

        @Override
        public Object accept(Frame frame, Object hash, Object key) {
            return NotProvided.INSTANCE;
        }
    }

    @CoreMethod(names={"[]"}, required=1)
    @ImportStatic(value={HashGuards.class})
    public static abstract class GetIndexNode
    extends CoreMethodArrayArgumentsNode
    implements PEBiFunction {
        @Node.Child
        private DispatchNode callDefaultNode;

        @Specialization(limit="hashStrategyLimit()")
        Object get(RubyHash hash, Object key, @CachedLibrary(value="hash.store") HashStoreLibrary hashes) {
            return hashes.lookupOrDefault(hash.store, null, hash, key, this);
        }

        @Override
        public Object accept(Frame frame, Object hash, Object key) {
            if (this.callDefaultNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callDefaultNode = (DispatchNode)this.insert(DispatchNode.create());
            }
            return this.callDefaultNode.call(hash, "default", key);
        }
    }

    @Primitive(name="hash_copy_and_mark_as_ruby2_keywords")
    public static abstract class HashCopyAndMarkAsRuby2KeywordsNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyHash copyAndMarkAsRuby2Keywords(RubyHash hash, @Cached CopyHashAndSetRuby2KeywordsNode copyHashAndSetRuby2KeywordsNode) {
            return copyHashAndSetRuby2KeywordsNode.execute(hash, true);
        }
    }

    public static abstract class CopyHashAndSetRuby2KeywordsNode
    extends RubyBaseNode {
        @NeverDefault
        public static CopyHashAndSetRuby2KeywordsNode create() {
            return HashNodesFactory.CopyHashAndSetRuby2KeywordsNodeGen.create();
        }

        public abstract RubyHash execute(RubyHash var1, boolean var2);

        @Specialization
        RubyHash copyAndSetRuby2Keywords(RubyHash self, boolean ruby2_keywords, @Cached KernelNodes.CopyInstanceVariablesNode copyInstanceVariablesNode, @Cached DispatchNode initializeDupNode) {
            RubyHash newObject = new RubyHash(self.getLogicalClass(), this.getLanguage().hashShape, this.getContext(), EmptyHashStore.NULL_HASH_STORE, 0, ruby2_keywords);
            copyInstanceVariablesNode.execute(newObject, self);
            initializeDupNode.call((Object)newObject, "initialize_dup", self);
            return newObject;
        }
    }

    @CoreMethod(names={"ruby2_keywords_hash?"}, onSingleton=true, required=1)
    public static abstract class IsRuby2KeywordsHashNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isRuby2KeywordsHash(RubyHash hash) {
            return hash.ruby2_keywords;
        }
    }

    @CoreMethod(names={"[]"}, constructor=true, rest=true)
    @ImportStatic(value={HashGuards.class})
    public static abstract class ConstructNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private DispatchNode fallbackNode;

        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
        @Specialization(guards={"isSmallArrayOfPairs(args, getLanguage())"})
        Object construct(RubyClass hashClass, Object[] args, @Cached HashingNodes.ToHashByHashCode hashNode) {
            RubyArray array = (RubyArray)args[0];
            Object[] store = (Object[])array.getStore();
            int size = array.size;
            Object[] newStore = PackedHashStoreLibrary.createStore();
            for (int n = 0; n < 3; ++n) {
                if (n >= size) continue;
                Object pair = store[n];
                if (!RubyGuards.isRubyArray(pair)) {
                    return this.fallback(hashClass, args);
                }
                RubyArray pairArray = (RubyArray)pair;
                Object pairStore = pairArray.getStore();
                if (pairStore.getClass() != Object[].class || pairArray.size != 2) {
                    return this.fallback(hashClass, args);
                }
                Object[] pairObjectStore = (Object[])pairStore;
                Object key = pairObjectStore[0];
                Object value = pairObjectStore[1];
                int hashed = hashNode.execute(this, key);
                PackedHashStoreLibrary.setHashedKeyValue(newStore, n, hashed, key, value);
            }
            Shape shape = this.getLanguage().hashShape;
            return new RubyHash(hashClass, shape, this.getContext(), newStore, size, false);
        }

        @Specialization(guards={"!isSmallArrayOfPairs(args, getLanguage())"})
        Object constructFallback(RubyClass hashClass, Object[] args) {
            return this.fallback(hashClass, args);
        }

        private Object fallback(RubyClass hashClass, Object[] args) {
            if (this.fallbackNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.fallbackNode = (DispatchNode)this.insert(DispatchNode.create());
            }
            return this.fallbackNode.call((Object)hashClass, "_constructor_fallback", args);
        }

        public boolean isSmallArrayOfPairs(Object[] args, RubyLanguage language) {
            if (args.length != 1) {
                return false;
            }
            Object arg = args[0];
            if (!RubyGuards.isRubyArray(arg)) {
                return false;
            }
            RubyArray array = (RubyArray)arg;
            Object store = array.getStore();
            if (store == null || store.getClass() != Object[].class) {
                return false;
            }
            Object[] objectStore = (Object[])store;
            return objectStore.length <= 3;
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyHash allocate(RubyClass rubyClass) {
            Shape shape = this.getLanguage().hashShape;
            EmptyHashStore store = EmptyHashStore.NULL_HASH_STORE;
            RubyHash hash = new RubyHash(rubyClass, shape, this.getContext(), store, 0, false);
            AllocationTracing.trace(hash, this);
            return hash;
        }
    }
}

