/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.hash;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownKeyException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.Set;
import org.truffleruby.RubyContext;
import org.truffleruby.collections.PEBiFunction;
import org.truffleruby.core.hash.HashGuards;
import org.truffleruby.core.hash.library.BucketsHashStore;
import org.truffleruby.core.hash.library.HashStoreLibrary;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.interop.ForeignToRubyNode;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.objects.IsFrozenNode;
import org.truffleruby.language.objects.ObjectGraph;
import org.truffleruby.language.objects.ObjectGraphNode;

@ExportLibrary(value=InteropLibrary.class)
@ImportStatic(value={HashGuards.class})
public final class RubyHash
extends RubyDynamicObject
implements ObjectGraphNode {
    public Object store;
    public int size;
    public Object defaultBlock;
    public Object defaultValue;
    public boolean compareByIdentity;
    public final boolean ruby2_keywords;
    private static final DefaultProvider NULL_PROVIDER = new DefaultProvider(null);

    public RubyHash(RubyClass rubyClass, Shape shape, RubyContext context, Object store, int size, boolean ruby2_keywords) {
        super(rubyClass, shape);
        this.store = store;
        this.size = size;
        this.defaultBlock = Nil.INSTANCE;
        this.defaultValue = Nil.INSTANCE;
        this.compareByIdentity = false;
        this.ruby2_keywords = ruby2_keywords;
        if (context.isPreInitializing()) {
            context.getPreInitializationManager().addPreInitHash(this);
        }
    }

    public boolean empty() {
        return this.size == 0;
    }

    @Override
    public String toString() {
        return super.toString() + "(size=" + this.size + ")";
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void getAdjacentObjects(Set<Object> reachable) {
        if (this.store instanceof BucketsHashStore) {
            ((BucketsHashStore)this.store).getAdjacentObjects(reachable);
        } else {
            ObjectGraph.addProperty(reachable, this.store);
        }
        ObjectGraph.addProperty(reachable, this.defaultBlock);
        ObjectGraph.addProperty(reachable, this.defaultValue);
    }

    @ExportMessage
    public boolean hasHashEntries() {
        return true;
    }

    @ExportMessage
    public long getHashSize() {
        return this.size;
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isHashEntryExisting", limit="hashStrategyLimit()"), @ExportMessage(name="isHashEntryReadable", limit="hashStrategyLimit()")})
    public final boolean isHashEntryExisting(Object key, @CachedLibrary(value="this.store") HashStoreLibrary hashStores, @Cached @Cached.Shared ForeignToRubyNode toRuby, @Bind(value="$node") Node node) {
        return hashStores.lookupOrDefault(this.store, null, this, toRuby.execute(node, key), NULL_PROVIDER) != null;
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isHashEntryModifiable"), @ExportMessage(name="isHashEntryRemovable")})
    public boolean isHashEntryModifiableAndRemovable(Object key, @CachedLibrary(value="this") InteropLibrary interop, @Cached @Cached.Shared IsFrozenNode isFrozenNode) {
        return !isFrozenNode.execute(this) && interop.isHashEntryExisting((Object)this, key);
    }

    @ExportMessage
    public boolean isHashEntryInsertable(Object key, @CachedLibrary(value="this") InteropLibrary interop, @Cached @Cached.Shared IsFrozenNode isFrozenNode) {
        return !isFrozenNode.execute(this) && !interop.isHashEntryExisting((Object)this, key);
    }

    @ExportMessage(limit="hashStrategyLimit()")
    public Object readHashValue(Object key, @CachedLibrary(value="this.store") HashStoreLibrary hashStores, @Cached @Cached.Shared ForeignToRubyNode toRuby, @Cached InlinedConditionProfile unknownKey, @Bind(value="$node") Node node) throws UnknownKeyException {
        Object value = hashStores.lookupOrDefault(this.store, null, this, toRuby.execute(node, key), NULL_PROVIDER);
        if (unknownKey.profile(node, value == null)) {
            throw UnknownKeyException.create((Object)key);
        }
        return value;
    }

    @ExportMessage(limit="hashStrategyLimit()")
    public Object readHashValueOrDefault(Object key, Object defaultValue, @CachedLibrary(value="this.store") HashStoreLibrary hashStores, @Cached @Cached.Shared ForeignToRubyNode toRuby, @Bind(value="$node") Node node) {
        return hashStores.lookupOrDefault(this.store, null, this, toRuby.execute(node, key), new DefaultProvider(defaultValue));
    }

    @ExportMessage
    public void writeHashEntry(Object key, Object value, @Cached @Cached.Exclusive DispatchNode set, @Cached @Cached.Shared IsFrozenNode isFrozenNode, @Cached @Cached.Shared ForeignToRubyNode toRuby, @Bind(value="$node") Node node) throws UnsupportedMessageException {
        if (isFrozenNode.execute(this)) {
            throw UnsupportedMessageException.create();
        }
        set.call(this, "[]=", toRuby.execute(node, key), value);
    }

    @ExportMessage
    public void removeHashEntry(Object key, @Cached @Cached.Exclusive DispatchNode delete, @Cached.Shared @Cached IsFrozenNode isFrozenNode, @CachedLibrary(value="this") InteropLibrary interop, @Cached @Cached.Shared ForeignToRubyNode toRuby, @Bind(value="$node") Node node) throws UnsupportedMessageException, UnknownKeyException {
        if (isFrozenNode.execute(this)) {
            throw UnsupportedMessageException.create();
        }
        if (!interop.isHashEntryExisting((Object)this, key)) {
            throw UnknownKeyException.create((Object)key);
        }
        delete.call((Object)this, "delete", toRuby.execute(node, key));
    }

    @ExportMessage
    public Object getHashEntriesIterator(@Cached @Cached.Exclusive DispatchNode eachPair) {
        return eachPair.call(this, "each_pair");
    }

    @ExportMessage
    public Object getHashKeysIterator(@Cached @Cached.Exclusive DispatchNode eachKey) {
        return eachKey.call(this, "each_key");
    }

    @ExportMessage
    public Object getHashValuesIterator(@Cached @Cached.Exclusive DispatchNode eachValue) {
        return eachValue.call(this, "each_value");
    }

    private static final class DefaultProvider
    implements PEBiFunction {
        private final Object defaultValue;

        private DefaultProvider(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public Object accept(Frame frame, Object hash, Object key) {
            return this.defaultValue;
        }
    }
}

