/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.hash.library;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.collections.PEBiFunction;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.hash.HashLiteralNode;
import org.truffleruby.core.hash.HashOperations;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.core.hash.library.HashStoreLibrary;
import org.truffleruby.core.hash.library.PackedHashStoreLibrary;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.objects.shared.PropagateSharingNode;

@ExportLibrary(value=HashStoreLibrary.class)
@GenerateUncached
public final class EmptyHashStore {
    public static final EmptyHashStore NULL_HASH_STORE = new EmptyHashStore();

    private EmptyHashStore() {
    }

    @ExportMessage
    protected Object lookupOrDefault(Frame frame, RubyHash hash, Object key, PEBiFunction defaultNode) {
        return defaultNode.accept(frame, hash, key);
    }

    @ExportMessage
    protected boolean set(RubyHash hash, Object key, Object value, boolean byIdentity, @CachedLibrary(limit="1") HashStoreLibrary packedHashStoreLibrary) {
        Object[] packedStore;
        hash.store = packedStore = PackedHashStoreLibrary.createStore();
        return packedHashStoreLibrary.set(packedStore, hash, key, value, byIdentity);
    }

    @ExportMessage
    protected void clear(RubyHash hash) {
    }

    @ExportMessage
    protected Object delete(RubyHash hash, Object key) {
        return null;
    }

    @ExportMessage
    protected Object deleteLast(RubyHash hash, Object key) {
        throw CompilerDirectives.shouldNotReachHere((String)"Cannot delete the last entry of an empty hash");
    }

    @ExportMessage
    protected Object eachEntry(RubyHash hash, HashStoreLibrary.EachEntryCallback callback, Object state) {
        return state;
    }

    @ExportMessage
    protected Object eachEntrySafe(RubyHash hash, HashStoreLibrary.EachEntryCallback callback, Object state) {
        return state;
    }

    @ExportMessage
    protected void replace(RubyHash hash, RubyHash dest, @Cached PropagateSharingNode propagateSharing, @Bind(value="$node") Node node) {
        if (hash == dest) {
            return;
        }
        propagateSharing.execute(node, dest, hash);
        dest.store = NULL_HASH_STORE;
        dest.size = 0;
        dest.defaultBlock = hash.defaultBlock;
        dest.defaultValue = hash.defaultValue;
        dest.compareByIdentity = hash.compareByIdentity;
        assert (this.verify(hash));
    }

    @ExportMessage
    protected RubyArray shift(RubyHash hash) {
        return null;
    }

    @ExportMessage
    protected void rehash(RubyHash hash) {
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public boolean verify(RubyHash hash) {
        assert (hash.store == this);
        assert (hash.store == NULL_HASH_STORE);
        assert (hash.size == 0);
        return true;
    }

    public static final class EmptyHashLiteralNode
    extends HashLiteralNode {
        public EmptyHashLiteralNode() {
            super(RubyNode.EMPTY_ARRAY);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return HashOperations.newEmptyHash(this.getContext(), this.getLanguage());
        }

        @Override
        public RubyNode cloneUninitialized() {
            EmptyHashLiteralNode copy = new EmptyHashLiteralNode();
            return copy.copyFlags(this);
        }
    }
}

