/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.inlined;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.encoding.EncodingNodes;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.inlined.BinaryInlinedOperationNode;
import org.truffleruby.core.inlined.InlinedEqualNodeGen;
import org.truffleruby.core.string.StringHelperNodes;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.dispatch.RubyCallNodeParameters;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.methods.LookupMethodOnSelfNode;

public abstract class InlinedEqualNode
extends BinaryInlinedOperationNode {
    protected static final String METHOD = "==";
    final Assumption integerEqualAssumption;
    final Assumption floatEqualAssumption;

    public InlinedEqualNode(RubyLanguage language, RubyCallNodeParameters callNodeParameters) {
        super(language, callNodeParameters, new Assumption[0]);
        this.integerEqualAssumption = language.coreMethodAssumptions.integerEqualAssumption;
        this.floatEqualAssumption = language.coreMethodAssumptions.floatEqualAssumption;
    }

    @Specialization(assumptions={"assumptions", "integerEqualAssumption"})
    boolean intEqual(int a, int b) {
        return a == b;
    }

    @Specialization(assumptions={"assumptions", "integerEqualAssumption"})
    boolean longEqual(long a, long b) {
        return a == b;
    }

    @Specialization(assumptions={"assumptions", "floatEqualAssumption"})
    boolean doDouble(double a, double b) {
        return a == b;
    }

    @Specialization(assumptions={"assumptions", "integerEqualAssumption"})
    boolean longDouble(long a, double b) {
        return (double)a == b;
    }

    @Specialization(assumptions={"assumptions", "floatEqualAssumption"})
    boolean doubleLong(double a, long b) {
        return a == (double)b;
    }

    @Specialization(guards={"libA.isRubyString(a)", "libB.isRubyString(b)", "lookupNode.lookupProtected(frame, a, METHOD) == coreMethods().STRING_EQUAL"}, assumptions={"assumptions"}, limit="1")
    static boolean stringEqual(VirtualFrame frame, Object a, Object b, @Cached RubyStringLibrary libA, @Cached RubyStringLibrary libB, @Cached LookupMethodOnSelfNode lookupNode, @Cached EncodingNodes.NegotiateCompatibleStringEncodingNode negotiateCompatibleStringEncodingNode, @Cached StringHelperNodes.StringEqualInternalNode stringEqualInternalNode, @Bind(value="this") Node node) {
        AbstractTruffleString tstringA = libA.getTString(a);
        RubyEncoding encA = libA.getEncoding(a);
        AbstractTruffleString tstringB = libB.getTString(b);
        RubyEncoding encB = libB.getEncoding(b);
        RubyEncoding compatibleEncoding = negotiateCompatibleStringEncodingNode.execute(node, tstringA, encA, tstringB, encB);
        return stringEqualInternalNode.executeInternal(node, tstringA, tstringB, compatibleEncoding);
    }

    @Specialization
    Object fallback(VirtualFrame frame, Object a, Object b) {
        return this.rewriteAndCall(frame, a, b);
    }

    @Override
    public RubyNode cloneUninitialized() {
        InlinedEqualNode copy = InlinedEqualNodeGen.create(this.getLanguage(), this.parameters, this.getLeftNode().cloneUninitialized(), this.getRightNode().cloneUninitialized());
        return copy.copyFlags(this);
    }
}

