/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.inlined;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.dispatch.RubyCallNode;
import org.truffleruby.language.dispatch.RubyCallNodeParameters;

public abstract class InlinedReplaceableNode
extends RubyContextSourceNode {
    protected final RubyCallNodeParameters parameters;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    protected final Assumption[] assumptions;
    private RubyCallNode replacedBy = null;

    protected InlinedReplaceableNode(RubyLanguage language, RubyCallNodeParameters callNodeParameters, Assumption ... assumptions) {
        this.parameters = callNodeParameters.withoutNodes();
        this.assumptions = new Assumption[1 + assumptions.length];
        this.assumptions[0] = language.traceFuncUnusedAssumption.getAssumption();
        ArrayUtils.arraycopy(assumptions, 0, this.assumptions, 1, assumptions.length);
    }

    protected RubyCallNode rewriteToCallNode() {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return (RubyCallNode)this.atomic(() -> {
            boolean found;
            boolean bl = found = !NodeUtil.forEachChild((Node)this.getParent(), node -> node != this);
            if (found) {
                RubyCallNode callNode = new RubyCallNode(this.parameters.withReceiverAndArguments(this.getReceiverNode(), this.getArgumentNodes(), this.getBlockNode()));
                callNode.copyFlags(this);
                this.replacedBy = callNode;
                return (RubyCallNode)this.replace(callNode, this + " could not be executed inline");
            }
            return this.replacedBy;
        });
    }

    protected abstract RubyNode getReceiverNode();

    protected abstract RubyNode[] getArgumentNodes();

    protected RubyNode getBlockNode() {
        assert (this.parameters.getBlock() == null);
        return null;
    }

    @Override
    public Object isDefined(VirtualFrame frame, RubyLanguage language, RubyContext context) {
        return this.rewriteToCallNode().isDefined(frame, language, context);
    }
}

