/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.method;

import com.oracle.truffle.api.Assumption;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.methods.SharedMethodInfo;

public final class MethodEntry {
    private final Assumption assumption;
    private final InternalMethod method;

    public MethodEntry(InternalMethod method) {
        assert (method != null);
        this.assumption = Assumption.create((String)"method is not overridden:");
        this.method = method;
    }

    public MethodEntry() {
        this.assumption = Assumption.create((String)"method is not defined:");
        this.method = null;
    }

    public MethodEntry withNewAssumption() {
        if (this.method != null) {
            return new MethodEntry(this.method);
        }
        return new MethodEntry();
    }

    public Assumption getAssumption() {
        return this.assumption;
    }

    public InternalMethod getMethod() {
        return this.method;
    }

    public void invalidate(RubyModule module, String methodName) {
        this.assumption.invalidate(SharedMethodInfo.moduleAndMethodName(module, methodName));
    }
}

