/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.method;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.Hashing;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.basicobject.ReferenceEqualNode;
import org.truffleruby.core.inlined.AlwaysInlinedMethodNode;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.method.RubyMethod;
import org.truffleruby.core.method.RubyUnboundMethod;
import org.truffleruby.core.module.MethodLookupResult;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.proc.ProcCallTargets;
import org.truffleruby.core.proc.ProcOperations;
import org.truffleruby.core.proc.ProcType;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyLambdaRootNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.arguments.ArgumentDescriptorUtils;
import org.truffleruby.language.arguments.EmptyArgumentsDescriptor;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.BreakID;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.methods.CallInternalMethodNode;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.methods.SharedMethodInfo;
import org.truffleruby.language.objects.AllocationTracing;
import org.truffleruby.language.objects.MetaClassNode;
import org.truffleruby.language.threadlocal.SpecialVariableStorage;
import org.truffleruby.parser.ArgumentDescriptor;

@CoreModule(value="Method", isClass=true)
public abstract class MethodNodes {
    public static boolean areInternalMethodEqual(InternalMethod a, InternalMethod b) {
        if (a == b || a.getSharedMethodInfo() == b.getSharedMethodInfo()) {
            return true;
        }
        return a.getSharedMethodInfo().getArity() == b.getSharedMethodInfo().getArity();
    }

    public static int hashInternalMethod(InternalMethod internalMethod) {
        return internalMethod.getSharedMethodInfo().getArity().hashCode();
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object allocate(RubyClass rubyClass) {
            throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorAllocatorUndefinedFor(rubyClass, this));
        }
    }

    @Primitive(name="method_unimplemented?")
    public static abstract class MethodIsUnimplementedNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean bound(RubyMethod rubyMethod) {
            return rubyMethod.method.isUnimplemented();
        }

        @Specialization
        boolean unbound(RubyUnboundMethod rubyMethod) {
            return rubyMethod.method.isUnimplemented();
        }
    }

    @Primitive(name="method_unimplement")
    public static abstract class MethodUnimplementNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object bound(RubyMethod rubyMethod) {
            this.unimplement(rubyMethod.method);
            return nil;
        }

        @Specialization
        Object unbound(RubyUnboundMethod rubyMethod) {
            this.unimplement(rubyMethod.method);
            return nil;
        }

        @CompilerDirectives.TruffleBoundary
        private void unimplement(InternalMethod method) {
            method.getDeclaringModule().fields.addMethod(this.getContext(), this, method.unimplemented());
        }
    }

    @CoreMethod(names={"to_proc"})
    public static abstract class ToProcNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isSingleContext()", "methodObject == cachedMethodObject"}, limit="getCacheLimit()")
        RubyProc toProcCachedSingleContext(RubyMethod methodObject, @Cached(value="methodObject") RubyMethod cachedMethodObject, @Cached(value="toProcUncached(cachedMethodObject)") RubyProc proc) {
            return proc;
        }

        @Specialization(guards={"methodObject.method.getCallTarget() == methodCallTarget"}, limit="getCacheLimit()", replaces={"toProcCachedSingleContext"})
        RubyProc toProcCachedTarget(RubyMethod methodObject, @Cached(value="methodObject.method.getCallTarget()") RootCallTarget methodCallTarget, @Cached(value="procCallTargetToCallRubyMethod(methodCallTarget)") RootCallTarget procCallTarget) {
            return this.createProc(procCallTarget, methodObject.method, methodObject.receiver);
        }

        @Specialization(replaces={"toProcCachedSingleContext", "toProcCachedTarget"})
        RubyProc toProcUncached(RubyMethod methodObject) {
            InternalMethod method = methodObject.method;
            Object receiver = methodObject.receiver;
            RootCallTarget callTarget = this.procCallTargetToCallRubyMethod(method.getCallTarget());
            return this.createProc(callTarget, method, receiver);
        }

        private RubyProc createProc(RootCallTarget callTarget, InternalMethod method, Object receiver) {
            Object[] packedArgs = RubyArguments.pack(null, null, method, null, receiver, nil, EmptyArgumentsDescriptor.INSTANCE, EMPTY_ARGUMENTS);
            SpecialVariableStorage variables = new SpecialVariableStorage();
            MaterializedFrame declarationFrame = this.getLanguage().createEmptyDeclarationFrame(packedArgs, variables);
            return ProcOperations.createRubyProc(this.coreLibrary().procClass, this.getLanguage().procShape, ProcType.LAMBDA, method.getSharedMethodInfo(), new ProcCallTargets(callTarget), declarationFrame, variables, method, null, method.getDeclarationContext());
        }

        @CompilerDirectives.TruffleBoundary
        protected RootCallTarget procCallTargetToCallRubyMethod(RootCallTarget callTarget) {
            RubyRootNode methodRootNode = RubyRootNode.of(callTarget);
            SharedMethodInfo sharedMethodInfo = methodRootNode.getSharedMethodInfo();
            CallWithRubyMethodReceiverNode callWithRubyMethodReceiverNode = new CallWithRubyMethodReceiverNode();
            RubyLambdaRootNode wrapRootNode = new RubyLambdaRootNode(this.getLanguage(), sharedMethodInfo.getSourceSection(), methodRootNode.getFrameDescriptor(), sharedMethodInfo, callWithRubyMethodReceiverNode, methodRootNode.getSplit(), methodRootNode.returnID, BreakID.INVALID, sharedMethodInfo.getArity());
            return wrapRootNode.getCallTarget();
        }

        protected int getCacheLimit() {
            return this.getLanguage().options.METHOD_TO_PROC_CACHE;
        }

        private static final class CallWithRubyMethodReceiverNode
        extends RubyContextSourceNode {
            @Node.Child
            private CallInternalMethodNode callInternalMethodNode = CallInternalMethodNode.create();

            private CallWithRubyMethodReceiverNode() {
            }

            @Override
            public Object execute(VirtualFrame frame) {
                MaterializedFrame declarationFrame = RubyArguments.getDeclarationFrame((Frame)frame);
                Object receiver = RubyArguments.getSelf((Frame)declarationFrame);
                InternalMethod method = RubyArguments.getMethod((Frame)declarationFrame);
                return CallNode.callBoundMethod((Frame)frame, method, receiver, frame.getArguments(), this.callInternalMethodNode);
            }

            @Override
            public RubyNode cloneUninitialized() {
                CallWithRubyMethodReceiverNode copy = new CallWithRubyMethodReceiverNode();
                return copy.copyFlags(this);
            }
        }
    }

    @CoreMethod(names={"unbind"})
    public static abstract class UnbindNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyUnboundMethod unbind(RubyMethod method, @Cached MetaClassNode metaClassNode) {
            RubyClass receiverClass = metaClassNode.execute(this, method.receiver);
            RubyUnboundMethod instance = new RubyUnboundMethod(this.coreLibrary().unboundMethodClass, this.getLanguage().unboundMethodShape, receiverClass, method.method);
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }

    @CoreMethod(names={"super_method"})
    public static abstract class SuperMethodNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object superMethod(RubyMethod method, @Cached MetaClassNode metaClassNode) {
            InternalMethod internalMethod = method.method;
            Object receiver = method.receiver;
            RubyClass selfMetaClass = metaClassNode.execute(this, receiver);
            MethodLookupResult superMethod = ModuleOperations.lookupSuperMethod(internalMethod, selfMetaClass);
            if (!superMethod.isDefined()) {
                return nil;
            }
            RubyMethod instance = new RubyMethod(this.coreLibrary().methodClass, this.getLanguage().methodShape, receiver, superMethod.getMethod());
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }

    @CoreMethod(names={"source_location"})
    public static abstract class SourceLocationNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object sourceLocation(RubyMethod method, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            SourceSection sourceSection = method.method.getSharedMethodInfo().getSourceSection();
            return this.getLanguage().rubySourceLocation(this.getContext(), sourceSection, fromJavaStringNode, this);
        }
    }

    @CoreMethod(names={"receiver"})
    public static abstract class ReceiverNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object receiver(RubyMethod method) {
            return method.receiver;
        }
    }

    @CoreMethod(names={"public?"})
    public static abstract class IsPublicNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isPublic(RubyMethod method) {
            return method.method.isPublic();
        }
    }

    @CoreMethod(names={"protected?"})
    public static abstract class IsProtectedNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isProtected(RubyMethod method) {
            return method.method.isProtected();
        }
    }

    @CoreMethod(names={"private?"})
    public static abstract class IsPrivateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isPrivate(RubyMethod method) {
            return method.method.isPrivate();
        }
    }

    @CoreMethod(names={"parameters"})
    public static abstract class ParametersNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray parameters(RubyMethod method) {
            ArgumentDescriptor[] argsDesc = method.method.getSharedMethodInfo().getArgumentDescriptors();
            return ArgumentDescriptorUtils.argumentDescriptorsToParameters(this.getLanguage(), this.getContext(), argsDesc, true);
        }
    }

    @CoreMethod(names={"owner"})
    public static abstract class OwnerNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyModule owner(RubyMethod method) {
            return method.method.getOwner();
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        long hash(RubyMethod rubyMethod) {
            InternalMethod method = rubyMethod.method;
            long h = this.getContext().getHashing(this).start(method.getDeclaringModule().hashCode());
            h = Hashing.update(h, rubyMethod.receiver.hashCode());
            h = Hashing.update(h, MethodNodes.hashInternalMethod(method));
            return Hashing.end(h);
        }
    }

    @CoreMethod(names={"name"})
    public static abstract class NameNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubySymbol name(RubyMethod method) {
            return this.getSymbol(method.method.getName());
        }
    }

    @CoreMethod(names={"call", "[]", "==="}, needsBlock=true, rest=true, alwaysInlined=true)
    @GenerateUncached
    public static abstract class CallNode
    extends AlwaysInlinedMethodNode {
        @Specialization
        Object call(Frame callerFrame, RubyMethod method, Object[] rubyArgs, RootCallTarget target, @Cached CallInternalMethodNode callInternalMethodNode) {
            InternalMethod internalMethod = method.method;
            Object receiver = method.receiver;
            return CallNode.callBoundMethod(callerFrame, internalMethod, receiver, rubyArgs, callInternalMethodNode);
        }

        static Object callBoundMethod(Frame frame, InternalMethod internalMethod, Object receiver, Object[] callerRubyArgs, CallInternalMethodNode callInternalMethodNode) {
            Object[] newArgs = RubyArguments.repack(callerRubyArgs, receiver);
            RubyArguments.setMethod(newArgs, internalMethod);
            assert (RubyArguments.assertFrameArguments(newArgs));
            return callInternalMethodNode.execute(frame, internalMethod, receiver, newArgs, null);
        }
    }

    @CoreMethod(names={"arity"})
    public static abstract class ArityNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int arity(RubyMethod method) {
            return method.method.getArityNumber();
        }
    }

    @CoreMethod(names={"==", "eql?"}, required=1)
    public static abstract class EqualNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean equal(RubyMethod a, RubyMethod b, @Cached ReferenceEqualNode referenceEqualNode) {
            return referenceEqualNode.execute(this, a.receiver, b.receiver) && a.method.getDeclaringModule() == b.method.getDeclaringModule() && MethodNodes.areInternalMethodEqual(a.method, b.method);
        }

        @Specialization(guards={"!isRubyMethod(b)"})
        boolean equal(RubyMethod a, Object b) {
            return false;
        }
    }

    @Primitive(name="same_methods?")
    public static abstract class SameMethodsNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean same(RubyMethod self, RubyMethod other) {
            return MethodNodes.areInternalMethodEqual(self.method, other.method);
        }

        @Specialization
        boolean same(RubyMethod self, RubyUnboundMethod other) {
            return MethodNodes.areInternalMethodEqual(self.method, other.method);
        }

        @Specialization
        boolean same(RubyUnboundMethod self, RubyMethod other) {
            return MethodNodes.areInternalMethodEqual(self.method, other.method);
        }

        @Specialization
        boolean same(RubyUnboundMethod self, RubyUnboundMethod other) {
            return MethodNodes.areInternalMethodEqual(self.method, other.method);
        }
    }
}

