/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.method;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.Hashing;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.cast.ToSymbolNode;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.method.MethodNodes;
import org.truffleruby.core.method.RubyMethod;
import org.truffleruby.core.method.RubyUnboundMethod;
import org.truffleruby.core.module.MethodLookupResult;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.arguments.ArgumentDescriptorUtils;
import org.truffleruby.language.arguments.ReadRestArgumentNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.methods.Arity;
import org.truffleruby.language.methods.CanBindMethodToModuleNode;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.methods.SharedMethodInfo;
import org.truffleruby.language.objects.AllocationTracing;
import org.truffleruby.language.objects.MetaClassNode;
import org.truffleruby.parser.ArgumentDescriptor;
import org.truffleruby.utils.Utils;

@CoreModule(value="UnboundMethod", isClass=true)
public abstract class UnboundMethodNodes {

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object allocate(RubyClass rubyClass) {
            throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorAllocatorUndefinedFor(rubyClass, this));
        }
    }

    @Primitive(name="unbound_method_ruby2_keywords")
    public static abstract class MethodRuby2KeywordsNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object ruby2Keywords(RubyUnboundMethod unboundMethod) {
            InternalMethod method = unboundMethod.method;
            return MethodRuby2KeywordsNode.ruby2Keywords(method.getSharedMethodInfo(), method.getCallTarget());
        }

        @CompilerDirectives.TruffleBoundary
        public static Object ruby2Keywords(SharedMethodInfo sharedMethodInfo, RootCallTarget callTarget) {
            Arity arity = sharedMethodInfo.getArity();
            if (!arity.hasRest() || arity.acceptsKeywords()) {
                return nil;
            }
            ReadRestArgumentNode readRestArgumentNode = (ReadRestArgumentNode)((Object)NodeUtil.findFirstNodeInstance((Node)callTarget.getRootNode(), ReadRestArgumentNode.class));
            if (readRestArgumentNode != null) {
                readRestArgumentNode.markKeywordHashWithFlag();
                return true;
            }
            return false;
        }
    }

    @CoreMethod(names={"super_method"})
    public static abstract class SuperMethodNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object superMethod(RubyUnboundMethod unboundMethod) {
            InternalMethod internalMethod = unboundMethod.method;
            RubyModule origin = unboundMethod.origin;
            MethodLookupResult superMethod = ModuleOperations.lookupSuperMethod(internalMethod, origin);
            if (!superMethod.isDefined()) {
                return nil;
            }
            RubyUnboundMethod instance = new RubyUnboundMethod(this.coreLibrary().unboundMethodClass, this.getLanguage().unboundMethodShape, superMethod.getMethod().getDeclaringModule(), superMethod.getMethod());
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }

    @CoreMethod(names={"source_location"})
    public static abstract class SourceLocationNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object sourceLocation(RubyUnboundMethod unboundMethod, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            SourceSection sourceSection = unboundMethod.method.getSharedMethodInfo().getSourceSection();
            return this.getLanguage().rubySourceLocation(this.getContext(), sourceSection, fromJavaStringNode, this);
        }
    }

    @CoreMethod(names={"parameters"})
    public static abstract class ParametersNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray parameters(RubyUnboundMethod method) {
            ArgumentDescriptor[] argsDesc = method.method.getSharedMethodInfo().getArgumentDescriptors();
            return ArgumentDescriptorUtils.argumentDescriptorsToParameters(this.getLanguage(), this.getContext(), argsDesc, true);
        }
    }

    @CoreMethod(names={"public?"})
    public static abstract class IsPublicNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isPublic(RubyUnboundMethod unboundMethod) {
            return unboundMethod.method.isPublic();
        }
    }

    @CoreMethod(names={"protected?"})
    public static abstract class IsProtectedNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isProtected(RubyUnboundMethod unboundMethod) {
            return unboundMethod.method.isProtected();
        }
    }

    @CoreMethod(names={"private?"})
    public static abstract class IsPrivateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isPrivate(RubyUnboundMethod unboundMethod) {
            return unboundMethod.method.isPrivate();
        }
    }

    @CoreMethod(names={"owner"})
    public static abstract class OwnerNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyModule owner(RubyUnboundMethod unboundMethod) {
            return unboundMethod.method.getOwner();
        }
    }

    @CoreMethod(names={"original_name"})
    public static abstract class OriginalNameNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubySymbol originalName(RubyUnboundMethod unboundMethod, @Cached ToSymbolNode toSymbolNode) {
            String originalName = unboundMethod.method.getOriginalName();
            return toSymbolNode.execute(this, originalName);
        }
    }

    @Primitive(name="unbound_method_origin")
    public static abstract class OriginNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyModule origin(RubyUnboundMethod unboundMethod) {
            return unboundMethod.origin;
        }
    }

    @CoreMethod(names={"name"})
    public static abstract class NameNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubySymbol name(RubyUnboundMethod unboundMethod) {
            return this.getSymbol(unboundMethod.method.getName());
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        long hash(RubyUnboundMethod rubyMethod) {
            InternalMethod method = rubyMethod.method;
            long h = this.getContext().getHashing(this).start(method.getDeclaringModule().hashCode());
            h = Hashing.update(h, MethodNodes.hashInternalMethod(method));
            return Hashing.end(h);
        }
    }

    @CoreMethod(names={"bind"}, required=1)
    public static abstract class BindNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyMethod bind(RubyUnboundMethod unboundMethod, Object object, @Cached MetaClassNode metaClassNode, @Cached CanBindMethodToModuleNode canBindMethodToModuleNode, @Cached InlinedBranchProfile errorProfile) {
            RubyClass objectMetaClass = metaClassNode.execute(this, object);
            if (!canBindMethodToModuleNode.executeCanBindMethodToModule(unboundMethod.method, objectMetaClass)) {
                errorProfile.enter((Node)this);
                RubyModule declaringModule = unboundMethod.method.getDeclaringModule();
                if (RubyGuards.isSingletonClass(declaringModule)) {
                    throw new RaiseException(this.getContext(), this.coreExceptions().typeError("singleton method called for a different object", this));
                }
                throw new RaiseException(this.getContext(), this.coreExceptions().typeError(Utils.concat((Object)"bind argument must be an instance of ", (Object)declaringModule.fields.getName()), this));
            }
            RubyMethod instance = new RubyMethod(this.coreLibrary().methodClass, this.getLanguage().methodShape, object, unboundMethod.method);
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }

    @CoreMethod(names={"arity"})
    public static abstract class ArityNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int arity(RubyUnboundMethod unboundMethod) {
            return unboundMethod.method.getArityNumber();
        }
    }

    @CoreMethod(names={"==", "eql?"}, required=1)
    public static abstract class EqualNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean equal(RubyUnboundMethod self, RubyUnboundMethod other) {
            return self.origin == other.origin && MethodNodes.areInternalMethodEqual(self.method, other.method);
        }

        @Specialization(guards={"!isRubyUnboundMethod(other)"})
        boolean equal(RubyUnboundMethod self, Object other) {
            return false;
        }
    }
}

