/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.module;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.CyclicAssumption;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.collections.ConcurrentOperations;
import org.truffleruby.collections.ConcurrentWeakSet;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.kernel.KernelNodes;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.method.MethodEntry;
import org.truffleruby.core.method.MethodFilter;
import org.truffleruby.core.module.AncestorIterator;
import org.truffleruby.core.module.IncludedModule;
import org.truffleruby.core.module.IncludedModulesIterator;
import org.truffleruby.core.module.ModuleChain;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.core.module.PrependMarker;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyConstant;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.constants.ConstantEntry;
import org.truffleruby.language.constants.GetConstantNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.loader.ReentrantLockFreeingMap;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.objects.IsFrozenNodeGen;
import org.truffleruby.language.objects.ObjectGraph;
import org.truffleruby.language.objects.ObjectGraphNode;
import org.truffleruby.language.objects.classvariables.ClassVariableStorage;
import org.truffleruby.language.objects.shared.SharedObjects;

public final class ModuleFields
extends ModuleChain
implements ObjectGraphNode {
    public final RubyModule rubyModule;
    private final RubyLanguage language;
    private final SourceSection sourceSection;
    private final PrependMarker start;
    private final RubyModule lexicalParent;
    public final String givenBaseName;
    private boolean hasFullName = false;
    private String name = null;
    private ImmutableRubyString rubyStringName;
    private boolean isRefinement = false;
    private RubyModule refinedModule;
    private RubyModule refinementNamespace;
    private final ConcurrentMap<String, MethodEntry> methods = new ConcurrentHashMap<String, MethodEntry>();
    private final ConcurrentMap<String, ConstantEntry> constants = new ConcurrentHashMap<String, ConstantEntry>();
    private final ClassVariableStorage classVariables;
    private final ConcurrentMap<RubyModule, RubyModule> refinements = new ConcurrentHashMap<RubyModule, RubyModule>();
    private final CyclicAssumption hierarchyUnmodifiedAssumption;
    private final Map<String, Assumption> inlinedBuiltinsAssumptions = new HashMap<String, Assumption>();
    private final ConcurrentWeakSet<RubyModule> includedBy;

    public static void debugModuleChain(RubyModule module) {
        StringBuilder builder = new StringBuilder();
        for (ModuleChain chain = module.fields; chain != null; chain = chain.getParentModule()) {
            builder.append(chain.getClass());
            if (!(chain instanceof PrependMarker)) {
                RubyModule real = ((ModuleChain)chain).getActualModule();
                builder.append(" " + real.fields.getName());
            }
            builder.append(System.lineSeparator());
        }
        RubyLanguage.LOGGER.info(builder.toString());
    }

    @CompilerDirectives.TruffleBoundary
    public ModuleFields(RubyLanguage language, SourceSection sourceSection, RubyModule lexicalParent, String givenBaseName, RubyModule rubyModule) {
        super(null);
        this.language = language;
        this.sourceSection = sourceSection;
        this.lexicalParent = lexicalParent;
        this.givenBaseName = givenBaseName;
        this.rubyModule = rubyModule;
        this.hierarchyUnmodifiedAssumption = rubyModule instanceof RubyClass ? null : new CyclicAssumption("hierarchy is unmodified");
        this.classVariables = new ClassVariableStorage(language);
        this.start = new PrependMarker(this);
        ConcurrentWeakSet concurrentWeakSet = this.includedBy = rubyModule instanceof RubyClass ? null : new ConcurrentWeakSet();
        if (lexicalParent == null && givenBaseName != null) {
            this.setFullName(givenBaseName);
        }
    }

    public void afterConstructed() {
        this.getName();
    }

    public RubyConstant getAdoptedByLexicalParent(RubyContext context, RubyModule lexicalParent, String name, Node currentNode) {
        assert (name != null);
        RubyConstant previous = lexicalParent.fields.setConstantInternal(context, currentNode, name, this.rubyModule, false);
        if (!this.hasFullName()) {
            RubyClass classClass = this.getLogicalClass().getLogicalClass();
            RubyClass objectClass = (RubyClass)((RubyClass)classClass.superclass).superclass;
            if (lexicalParent == objectClass) {
                this.setFullName(name);
                this.updateAnonymousChildrenModules(context);
            } else if (lexicalParent.fields.hasFullName()) {
                this.setFullName(lexicalParent.fields.getName() + "::" + name);
                this.updateAnonymousChildrenModules(context);
            }
        }
        return previous;
    }

    public void updateAnonymousChildrenModules(RubyContext context) {
        for (Map.Entry entry : this.constants.entrySet()) {
            ConstantEntry constantEntry = (ConstantEntry)entry.getValue();
            RubyConstant constant = constantEntry.getConstant();
            if (constant == null || !constant.hasValue() || !(constant.getValue() instanceof RubyModule)) continue;
            RubyModule module = (RubyModule)constant.getValue();
            if (module.fields.hasFullName()) continue;
            module.fields.getAdoptedByLexicalParent(context, this.rubyModule, (String)entry.getKey(), null);
        }
    }

    public boolean hasPrependedModules() {
        return this.start.getParentModule() != this;
    }

    public ModuleChain getFirstModuleChain() {
        return this.start.getParentModule();
    }

    @CompilerDirectives.TruffleBoundary
    public void initCopy(RubyModule from) {
        ModuleFields fromFields = from.fields;
        for (MethodEntry methodEntry : fromFields.methods.values()) {
            if (methodEntry.getMethod() == null) continue;
            MethodEntry newMethodEntry = new MethodEntry(methodEntry.getMethod().withDeclaringModule(this.rubyModule).withOwner(this.rubyModule));
            this.methods.put(methodEntry.getMethod().getName(), newMethodEntry);
        }
        for (Map.Entry entry : fromFields.constants.entrySet()) {
            RubyConstant constant = ((ConstantEntry)entry.getValue()).getConstant();
            if (constant == null) continue;
            this.constants.put((String)entry.getKey(), new ConstantEntry(constant));
        }
        for (Object object : fromFields.classVariables.getShape().getKeys()) {
            Object value = fromFields.classVariables.read((String)object, DynamicObjectLibrary.getUncached());
            if (value == null) continue;
            this.classVariables.put((String)object, value, DynamicObjectLibrary.getUncached());
        }
        this.parentModule = fromFields.hasPrependedModules() ? fromFields.start.getParentModule() : fromFields.parentModule;
    }

    public void checkFrozen(RubyContext context, Node currentNode) {
        if (context.getCoreLibrary() != null && IsFrozenNodeGen.getUncached().execute(this.rubyModule)) {
            String name;
            RubyDynamicObject receiver = this.rubyModule;
            if (this.rubyModule instanceof RubyClass) {
                RubyClass cls = (RubyClass)this.rubyModule;
                name = "object";
                if (cls.isSingleton) {
                    receiver = cls.attached;
                    if (cls.attached instanceof RubyClass) {
                        name = "Class";
                    } else if (cls.attached instanceof RubyModule) {
                        name = "Module";
                    }
                } else {
                    name = "class";
                }
            } else {
                name = "module";
            }
            throw new RaiseException(context, context.getCoreExceptions().frozenError(StringUtils.format("can't modify frozen %s", name), currentNode, (Object)receiver));
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void include(RubyContext context, Node currentNode, RubyModule module) {
        this.checkFrozen(context, currentNode);
        if (ModuleOperations.includesModule(module, this.rubyModule)) {
            throw new RaiseException(context, context.getCoreExceptions().argumentError("cyclic include detected", currentNode));
        }
        SharedObjects.propagate(context.getLanguageSlow(), this.rubyModule, module);
        ModuleChain inclusionPoint = this;
        ArrayDeque<RubyModule> modulesToInclude = new ArrayDeque<RubyModule>();
        for (RubyModule ancestor : module.fields.ancestors()) {
            if (ModuleOperations.includesModule(this.rubyModule, ancestor)) {
                if (!this.isIncludedModuleBeforeSuperClass(ancestor)) continue;
                this.performIncludes(inclusionPoint, modulesToInclude);
                assert (modulesToInclude.isEmpty());
                inclusionPoint = this.parentModule;
                while (inclusionPoint.getActualModule() != ancestor) {
                    inclusionPoint = inclusionPoint.getParentModule();
                }
                continue;
            }
            modulesToInclude.push(ancestor);
        }
        this.performIncludes(inclusionPoint, modulesToInclude);
        this.newHierarchyVersion();
    }

    private void performIncludes(ModuleChain inclusionPoint, Deque<RubyModule> moduleAncestors) {
        while (!moduleAncestors.isEmpty()) {
            RubyModule toInclude = moduleAncestors.pop();
            inclusionPoint.insertAfter(toInclude);
            toInclude.fields.includedBy.add(this.rubyModule);
            this.newConstantsVersion(toInclude.fields.getConstantNames());
            if (!(this.rubyModule instanceof RubyClass)) continue;
            this.newMethodsVersion(toInclude.fields.getMethodNames());
        }
    }

    private boolean isIncludedModuleBeforeSuperClass(RubyModule module) {
        ModuleChain included = this.parentModule;
        while (included instanceof IncludedModule) {
            if (included.getActualModule() == module) {
                return true;
            }
            included = included.getParentModule();
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public void prepend(RubyContext context, Node currentNode, RubyModule module) {
        this.checkFrozen(context, currentNode);
        if (ModuleOperations.includesModule(module, this.rubyModule)) {
            throw new RaiseException(context, context.getCoreExceptions().argumentError("cyclic prepend detected", currentNode));
        }
        SharedObjects.propagate(context.getLanguageSlow(), this.rubyModule, module);
        List<RubyModule> prependedModulesAndSelf = this.getPrependedModulesAndSelf();
        ModuleChain cur = this.start;
        for (ModuleChain mod = module.fields.start; !(mod == null || mod instanceof ModuleFields && ((ModuleFields)mod).rubyModule instanceof RubyClass); mod = mod.getParentModule()) {
            RubyModule toPrepend;
            if (mod instanceof PrependMarker || ModuleOperations.includesModule(this.rubyModule, toPrepend = ((ModuleChain)mod).getActualModule())) continue;
            cur.insertAfter(toPrepend);
            List<String> constantsToInvalidate = toPrepend.fields.getConstantNames();
            boolean isClass = this.rubyModule instanceof RubyClass;
            List<String> methodsToInvalidate = isClass ? toPrepend.fields.getMethodNames() : null;
            for (RubyModule moduleToInvalidate : prependedModulesAndSelf) {
                toPrepend.fields.includedBy.add(moduleToInvalidate);
                moduleToInvalidate.fields.newConstantsVersion(constantsToInvalidate);
                if (!isClass) continue;
                moduleToInvalidate.fields.newMethodsVersion(methodsToInvalidate);
            }
            cur = cur.getParentModule();
        }
        this.newHierarchyVersion();
        this.invalidateBuiltinsAssumptions();
    }

    private List<RubyModule> getPrependedModulesAndSelf() {
        ArrayList<RubyModule> prependedModulesAndSelf = new ArrayList<RubyModule>();
        for (ModuleChain chain = this.getFirstModuleChain(); chain != this; chain = chain.getParentModule()) {
            prependedModulesAndSelf.add(chain.getActualModule());
        }
        prependedModulesAndSelf.add(this.rubyModule);
        return prependedModulesAndSelf;
    }

    @CompilerDirectives.TruffleBoundary
    public RubyConstant setConstant(RubyContext context, Node currentNode, String name, Object value) {
        if (value instanceof RubyModule) {
            return ((RubyModule)value).fields.getAdoptedByLexicalParent(context, this.rubyModule, name, currentNode);
        }
        return this.setConstantInternal(context, currentNode, name, value, false);
    }

    @CompilerDirectives.TruffleBoundary
    public void setAutoloadConstant(RubyContext context, Node currentNode, String name, Object filename, String javaFilename) {
        ReentrantLockFreeingMap<String> fileLocks;
        ReentrantLock lock;
        RubyConstant autoloadConstant = this.setConstantInternal(context, currentNode, name, filename, true);
        if (autoloadConstant == null) {
            return;
        }
        if (context.getOptions().LOG_AUTOLOAD) {
            RubyLanguage.LOGGER.info(() -> String.format("%s: setting up autoload %s with %s", context.fileLine(context.getCallStack().getTopMostUserSourceSection()), autoloadConstant, filename));
        }
        if ((lock = (fileLocks = context.getFeatureLoader().getFileLocks()).get(javaFilename)).isLocked()) {
            GetConstantNode.autoloadConstantStart(context, autoloadConstant, currentNode);
        }
        context.getFeatureLoader().addAutoload(autoloadConstant);
    }

    @CompilerDirectives.TruffleBoundary
    private RubyConstant setConstantInternal(RubyContext context, Node currentNode, String name, Object value, boolean autoload) {
        RubyConstant previous;
        RubyConstant newConstant;
        ConstantEntry previousEntry;
        this.checkFrozen(context, currentNode);
        SharedObjects.propagate(context.getLanguageSlow(), this.rubyModule, value);
        String autoloadPath = autoload ? RubyGuards.getJavaString(value) : null;
        do {
            RubyConstant rubyConstant = previous = (previousEntry = (ConstantEntry)this.constants.get(name)) != null ? previousEntry.getConstant() : null;
            if (!autoload || previous == null) continue;
            if (previous.hasValue()) {
                return null;
            }
            if (!previous.isAutoload() || !previous.getAutoloadConstant().getAutoloadPath().equals(autoloadPath)) continue;
            return null;
        } while (!ConcurrentOperations.replace(this.constants, name, previousEntry, new ConstantEntry(newConstant = this.newConstant(currentNode, name, value, autoload, previous))));
        if (previousEntry != null) {
            previousEntry.invalidate("set", this.rubyModule, name);
        }
        if (this.includedBy != null) {
            this.invalidateConstantIncludedBy(name);
        }
        if (context.isConstAddedEverDefined()) {
            RubySymbol nameSymbol = context.getLanguageSlow().getSymbol(name);
            RubyContext.send(currentNode, this.rubyModule, "const_added", nameSymbol);
        }
        return autoload ? newConstant : previous;
    }

    private RubyConstant newConstant(Node currentNode, String name, Object value, boolean autoload, RubyConstant previous) {
        boolean isPrivate = previous != null && previous.isPrivate();
        boolean isDeprecated = previous != null && previous.isDeprecated();
        SourceSection sourceSection = currentNode != null ? currentNode.getSourceSection() : null;
        return new RubyConstant(this.rubyModule, name, value, isPrivate, autoload, isDeprecated, sourceSection);
    }

    @CompilerDirectives.TruffleBoundary
    public RubyConstant removeConstant(RubyContext context, Node currentNode, String name) {
        this.checkFrozen(context, currentNode);
        ConstantEntry oldConstant = (ConstantEntry)this.constants.remove(name);
        if (oldConstant != null) {
            oldConstant.invalidate("remove", this.rubyModule, name);
            return oldConstant.getConstant();
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public void addMethod(RubyContext context, Node currentNode, InternalMethod method) {
        assert (ModuleOperations.canBindMethodTo(method, this.rubyModule) || ModuleOperations.assignableTo(context.getCoreLibrary().objectClass, method.getDeclaringModule()) || method.isUndefined() && this.methods.get(method.getName()) != null);
        this.checkFrozen(context, currentNode);
        method = method.withOwner(this.rubyModule);
        if (SharedObjects.isShared(this.rubyModule)) {
            Set<Object> adjacent = ObjectGraph.newObjectSet();
            ObjectGraph.addProperty(adjacent, method);
            for (Object object : adjacent) {
                SharedObjects.writeBarrier(context.getLanguageSlow(), object);
            }
        }
        MethodEntry previousMethodEntry = this.methods.put(method.getName(), new MethodEntry(method));
        if (!context.getCoreLibrary().isInitializing()) {
            if (previousMethodEntry != null) {
                previousMethodEntry.invalidate(this.rubyModule, method.getName());
            }
            if (this.includedBy != null) {
                this.invalidateMethodIncludedBy(method.getName());
            }
            this.changedMethod(method.getName());
            if (this.refinedModule != null) {
                this.refinedModule.fields.changedMethod(method.getName());
            }
        }
        if (context.getCoreLibrary().isLoaded() && !method.isUndefined() && (previousMethodEntry == null || previousMethodEntry.getMethod() == null || previousMethodEntry.getMethod().getSharedMethodInfo() != method.getSharedMethodInfo())) {
            RubySymbol methodSymbol = context.getLanguageSlow().getSymbol(method.getName());
            if (RubyGuards.isSingletonClass(this.rubyModule)) {
                RubyDynamicObject receiver = ((RubyClass)this.rubyModule).attached;
                RubyContext.send(currentNode, (Object)receiver, "singleton_method_added", methodSymbol);
            } else {
                RubyContext.send(currentNode, this.rubyModule, "method_added", methodSymbol);
            }
        }
        if (context.getCoreLibrary().isLoaded() && method.getName().equals("const_added")) {
            RubyLanguage.getCurrentContext().constAddedIsDefined();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public boolean removeMethod(String methodName) {
        InternalMethod method = this.getMethod(methodName);
        if (method == null) {
            return false;
        }
        MethodEntry removedEntry = (MethodEntry)this.methods.remove(methodName);
        if (removedEntry != null) {
            removedEntry.invalidate(this.rubyModule, methodName);
        }
        this.changedMethod(methodName);
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public void undefMethod(RubyLanguage language, RubyContext context, Node currentNode, String methodName) {
        this.checkFrozen(context, currentNode);
        InternalMethod method = ModuleOperations.lookupMethodUncached(this.rubyModule, methodName, null);
        if (method == null || method.isUndefined()) {
            RubyModule moduleForError = RubyGuards.isMetaClass(this.rubyModule) ? (RubyModule)((RubyClass)this.rubyModule).attached : this.rubyModule;
            throw new RaiseException(context, (RubyException)context.getCoreExceptions().nameErrorUndefinedMethod(methodName, moduleForError, currentNode));
        }
        this.addMethod(context, currentNode, method.undefined());
        RubySymbol methodSymbol = language.getSymbol(methodName);
        if (RubyGuards.isSingletonClass(this.rubyModule)) {
            RubyDynamicObject receiver = ((RubyClass)this.rubyModule).attached;
            RubyContext.send(currentNode, (Object)receiver, "singleton_method_undefined", methodSymbol);
        } else {
            RubyContext.send(currentNode, this.rubyModule, "method_undefined", methodSymbol);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public InternalMethod deepMethodSearch(RubyContext context, String name) {
        InternalMethod method = ModuleOperations.lookupMethodUncached(this.rubyModule, name, null);
        if (method != null && !method.isUndefined()) {
            return method;
        }
        if (!(this.rubyModule instanceof RubyClass) && (method = ModuleOperations.lookupMethodUncached(context.getCoreLibrary().objectClass, name, null)) != null && !method.isUndefined()) {
            return method;
        }
        if (this.isRefinement()) {
            return this.getRefinedModule().fields.deepMethodSearch(context, name);
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public void changeConstantVisibility(RubyContext context, Node currentNode, String name, boolean isPrivate) {
        RubyConstant previous;
        ConstantEntry previousEntry;
        do {
            RubyConstant rubyConstant = previous = (previousEntry = (ConstantEntry)this.constants.get(name)) != null ? previousEntry.getConstant() : null;
            if (previous != null) continue;
            throw new RaiseException(context, (RubyException)context.getCoreExceptions().nameErrorUninitializedConstant(this.rubyModule, name, currentNode));
        } while (!this.constants.replace(name, previousEntry, new ConstantEntry(previous.withPrivate(isPrivate))));
        previousEntry.invalidate("change visibility", this.rubyModule, name);
    }

    @CompilerDirectives.TruffleBoundary
    public void deprecateConstant(RubyContext context, Node currentNode, String name) {
        block1: {
            RubyConstant previous;
            ConstantEntry previousEntry;
            do {
                RubyConstant rubyConstant = previous = (previousEntry = (ConstantEntry)this.constants.get(name)) != null ? previousEntry.getConstant() : null;
                if (previous != null) continue;
                throw new RaiseException(context, (RubyException)context.getCoreExceptions().nameErrorUninitializedConstant(this.rubyModule, name, currentNode));
            } while (!this.constants.replace(name, previousEntry, new ConstantEntry(previous.withDeprecated())));
            if (previousEntry == null) break block1;
            previousEntry.invalidate("deprecate", this.rubyModule, name);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public boolean undefineConstantIfStillAutoload(RubyConstant autoloadConstant) {
        boolean replace;
        ConstantEntry constantEntry = (ConstantEntry)this.constants.get(autoloadConstant.getName());
        boolean bl = replace = constantEntry != null && constantEntry.getConstant() == autoloadConstant;
        if (replace && this.constants.replace(autoloadConstant.getName(), constantEntry, new ConstantEntry(autoloadConstant.undefined()))) {
            constantEntry.invalidate("undefine if still autoload", this.rubyModule, autoloadConstant.getName());
            return true;
        }
        return false;
    }

    public String getName() {
        String name = this.name;
        if (name == null) {
            return this.getAnonymousName();
        }
        return name;
    }

    @CompilerDirectives.TruffleBoundary
    public String getSimpleName() {
        String name = this.getName();
        int i = name.lastIndexOf("::");
        if (i == -1) {
            return name;
        }
        return name.substring(i + "::".length());
    }

    @CompilerDirectives.TruffleBoundary
    private String getAnonymousName() {
        String anonymousName = this.createAnonymousName();
        this.setName(anonymousName);
        return anonymousName;
    }

    public void setFullName(String name) {
        assert (name != null);
        this.hasFullName = true;
        this.setName(name);
    }

    private void setName(String name) {
        this.name = name;
        if (this.hasPartialName()) {
            this.rubyStringName = this.language.getFrozenStringLiteral(TStringUtils.utf8TString(name), Encodings.UTF_8);
        }
    }

    public Object getRubyStringName() {
        if (this.hasPartialName()) {
            if (this.rubyStringName == null) {
                this.getName();
            }
            assert (this.rubyStringName != null);
            return this.rubyStringName;
        }
        return Nil.INSTANCE;
    }

    @CompilerDirectives.TruffleBoundary
    private String createAnonymousName() {
        if (this.givenBaseName != null) {
            return this.lexicalParent.fields.getName() + "::" + this.givenBaseName;
        }
        if (this.getLogicalClass() == this.rubyModule) {
            return "#<cyclic>";
        }
        if (RubyGuards.isSingletonClass(this.rubyModule)) {
            RubyDynamicObject attached = ((RubyClass)this.rubyModule).attached;
            String attachedName = attached instanceof RubyModule ? ((RubyModule)attached).fields.getName() : KernelNodes.ToSNode.uncachedBasicToS(attached);
            return "#<Class:" + attachedName + ">";
        }
        if (this.isRefinement) {
            return this.getRefinementName();
        }
        return KernelNodes.ToSNode.uncachedBasicToS(this.rubyModule);
    }

    @CompilerDirectives.TruffleBoundary
    public String getRefinementName() {
        assert (this.isRefinement);
        return "#<refinement:" + this.refinedModule.fields.getName() + "@" + this.refinementNamespace.fields.getName() + ">";
    }

    public boolean hasFullName() {
        return this.hasFullName;
    }

    public boolean hasPartialName() {
        return this.hasFullName() || this.givenBaseName != null;
    }

    public boolean isAnonymous() {
        return !this.hasFullName;
    }

    private boolean isClass() {
        return this.rubyModule instanceof RubyClass;
    }

    public boolean isRefinement() {
        return this.isRefinement;
    }

    public void setupRefinementModule(RubyModule refinedModule, RubyModule refinementNamespace) {
        this.isRefinement = true;
        this.refinedModule = refinedModule;
        this.refinementNamespace = refinementNamespace;
        this.parentModule = refinedModule.fields.start;
    }

    public RubyModule getRefinedModule() {
        return this.refinedModule;
    }

    public RubyModule getRefinementNamespace() {
        return this.refinementNamespace;
    }

    public String toString() {
        return super.toString() + "(" + this.getName() + ")";
    }

    public void newHierarchyVersion() {
        if (!this.isClass()) {
            this.hierarchyUnmodifiedAssumption.invalidate(this.getName());
        }
        if (this.isRefinement()) {
            this.getRefinedModule().fields.invalidateBuiltinsAssumptions();
        }
    }

    private void invalidateMethodIncludedBy(String method) {
        for (RubyModule module : this.includedBy) {
            module.fields.newMethodVersion(method);
        }
    }

    private void invalidateConstantIncludedBy(String constantName) {
        for (RubyModule module : this.includedBy) {
            module.fields.newConstantVersion(constantName);
        }
    }

    public void newConstantsVersion(Collection<String> constantsToInvalidate) {
        for (String name : constantsToInvalidate) {
            this.newConstantVersion(name);
        }
    }

    public void newConstantVersion(String constantToInvalidate) {
        ConstantEntry constantEntry;
        do {
            if ((constantEntry = (ConstantEntry)this.constants.get(constantToInvalidate)) != null) continue;
            return;
        } while (!this.constants.replace(constantToInvalidate, constantEntry, constantEntry.withNewAssumption()));
        constantEntry.invalidate("newConstantVersion", this.rubyModule, constantToInvalidate);
    }

    public void newMethodsVersion(Collection<String> methodsToInvalidate) {
        for (String name : methodsToInvalidate) {
            this.newMethodVersion(name);
        }
    }

    private void newMethodVersion(String methodToInvalidate) {
        MethodEntry methodEntry;
        do {
            if ((methodEntry = (MethodEntry)this.methods.get(methodToInvalidate)) != null) continue;
            return;
        } while (!this.methods.replace(methodToInvalidate, methodEntry, methodEntry.withNewAssumption()));
        methodEntry.invalidate(this.rubyModule, methodToInvalidate);
    }

    public Assumption getHierarchyUnmodifiedAssumption() {
        assert (!this.isClass());
        return this.hierarchyUnmodifiedAssumption.getAssumption();
    }

    public Iterable<Map.Entry<String, ConstantEntry>> getConstants() {
        return this.constants.entrySet();
    }

    @CompilerDirectives.TruffleBoundary
    public ConstantEntry getOrComputeConstantEntry(String name) {
        return ConcurrentOperations.getOrCompute(this.constants, name, n -> new ConstantEntry());
    }

    @CompilerDirectives.TruffleBoundary
    public RubyConstant getConstant(String name) {
        ConstantEntry constantEntry = (ConstantEntry)this.constants.get(name);
        return constantEntry != null ? constantEntry.getConstant() : null;
    }

    public Iterable<InternalMethod> getMethods() {
        return () -> new MethodsIterator(this.methods.values());
    }

    public List<String> getConstantNames() {
        ArrayList<String> results = new ArrayList<String>();
        for (Map.Entry entry : this.constants.entrySet()) {
            if (((ConstantEntry)entry.getValue()).getConstant() == null) continue;
            results.add((String)entry.getKey());
        }
        return results;
    }

    public List<String> getMethodNames() {
        ArrayList<String> results = new ArrayList<String>();
        for (Map.Entry entry : this.methods.entrySet()) {
            if (((MethodEntry)entry.getValue()).getMethod() == null) continue;
            results.add((String)entry.getKey());
        }
        return results;
    }

    @CompilerDirectives.TruffleBoundary
    public InternalMethod getMethod(String name) {
        MethodEntry methodEntry = (MethodEntry)this.methods.get(name);
        if (methodEntry != null) {
            return methodEntry.getMethod();
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public InternalMethod getMethodAndAssumption(String name, List<Assumption> assumptions) {
        MethodEntry methodEntry = ConcurrentOperations.getOrCompute(this.methods, name, n -> new MethodEntry());
        assumptions.add(methodEntry.getAssumption());
        return methodEntry.getMethod();
    }

    @CompilerDirectives.TruffleBoundary
    public Assumption getOrCreateMethodAssumption(String name) {
        return ConcurrentOperations.getOrCompute(this.methods, name, n -> new MethodEntry()).getAssumption();
    }

    public ClassVariableStorage getClassVariables() {
        return this.classVariables;
    }

    public ConcurrentMap<RubyModule, RubyModule> getRefinements() {
        return this.refinements;
    }

    public void setSuperClass(RubyClass superclass) {
        assert (this.rubyModule instanceof RubyClass);
        this.parentModule = superclass.fields.start;
    }

    @Override
    public RubyModule getActualModule() {
        return this.rubyModule;
    }

    public Iterable<RubyModule> ancestors() {
        return () -> new AncestorIterator(this.start);
    }

    public Iterable<RubyModule> prependedAndIncludedModules() {
        return () -> new IncludedModulesIterator(this.start, this);
    }

    public Collection<RubySymbol> filterMethods(RubyLanguage language, boolean includeAncestors, MethodFilter filter) {
        Map<String, InternalMethod> allMethods = includeAncestors ? ModuleOperations.getAllMethods(this.rubyModule) : this.getInternalMethodMap();
        return this.filterMethods(language, allMethods, filter);
    }

    public Collection<RubySymbol> filterMethodsOnObject(RubyLanguage language, boolean includeAncestors, MethodFilter filter) {
        Map<String, InternalMethod> allMethods = includeAncestors ? ModuleOperations.getAllMethods(this.rubyModule) : ModuleOperations.getMethodsUntilLogicalClass(this.rubyModule);
        return this.filterMethods(language, allMethods, filter);
    }

    public Collection<RubySymbol> filterSingletonMethods(RubyLanguage language, boolean includeAncestors, MethodFilter filter) {
        Map<String, InternalMethod> allMethods = includeAncestors ? ModuleOperations.getMethodsBeforeLogicalClass(this.rubyModule) : this.getInternalMethodMap();
        return this.filterMethods(language, allMethods, filter);
    }

    public Collection<RubySymbol> filterMethods(RubyLanguage language, Map<String, InternalMethod> allMethods, MethodFilter filter) {
        Map<String, InternalMethod> methods = ModuleOperations.withoutUndefinedMethods(allMethods);
        HashSet<RubySymbol> filtered = new HashSet<RubySymbol>();
        for (InternalMethod method : methods.values()) {
            if (!filter.filter(method)) continue;
            filtered.add(language.getSymbol(method.getName()));
        }
        return filtered;
    }

    public boolean anyMethodDefined() {
        for (MethodEntry value : this.methods.values()) {
            if (value.getMethod() == null) continue;
            return true;
        }
        return false;
    }

    private Map<String, InternalMethod> getInternalMethodMap() {
        HashMap<String, InternalMethod> map = new HashMap<String, InternalMethod>();
        for (Map.Entry e : this.methods.entrySet()) {
            if (((MethodEntry)e.getValue()).getMethod() == null) continue;
            map.put((String)e.getKey(), ((MethodEntry)e.getValue()).getMethod());
        }
        return map;
    }

    public RubyClass getLogicalClass() {
        return this.rubyModule.getLogicalClass();
    }

    @Override
    public void getAdjacentObjects(Set<Object> adjacent) {
        if (this.lexicalParent != null) {
            adjacent.add(this.lexicalParent);
        }
        for (RubyModule module : this.prependedAndIncludedModules()) {
            ObjectGraph.addProperty(adjacent, module);
        }
        if (this.rubyModule instanceof RubyClass) {
            ObjectGraph.addProperty(adjacent, ((RubyClass)this.rubyModule).superclass);
        }
        for (ConstantEntry constant : this.constants.values()) {
            if (constant.getConstant() == null) continue;
            ObjectGraph.addProperty(adjacent, constant.getConstant());
        }
        for (RubyModule key : this.classVariables.getShape().getKeys()) {
            Object value = this.classVariables.read((String)((Object)key), DynamicObjectLibrary.getUncached());
            if (value == null) continue;
            ObjectGraph.addProperty(adjacent, value);
        }
        for (MethodEntry methodEntry : this.methods.values()) {
            if (methodEntry.getMethod() == null) continue;
            ObjectGraph.addProperty(adjacent, methodEntry.getMethod());
        }
    }

    public SourceSection getSourceSection() {
        return this.sourceSection;
    }

    public void registerAssumption(String methodName, Assumption assumption) {
        assert (RubyLanguage.getCurrentContext().getCoreLibrary().isInitializing());
        Assumption old = this.inlinedBuiltinsAssumptions.put(methodName, assumption);
        assert (old == null);
    }

    private void changedMethod(String name) {
        Assumption assumption = this.inlinedBuiltinsAssumptions.get(name);
        if (assumption != null) {
            assumption.invalidate();
        }
    }

    private void invalidateBuiltinsAssumptions() {
        if (!this.inlinedBuiltinsAssumptions.isEmpty()) {
            for (Assumption assumption : this.inlinedBuiltinsAssumptions.values()) {
                assumption.invalidate();
            }
        }
    }

    private static final class MethodsIterator
    implements Iterator<InternalMethod> {
        final Iterator<MethodEntry> methodEntries;
        InternalMethod nextElement;

        MethodsIterator(Collection<MethodEntry> methodEntries) {
            this.methodEntries = methodEntries.iterator();
            this.computeNext();
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        @Override
        public InternalMethod next() {
            InternalMethod element = this.nextElement;
            if (element == null) {
                throw new NoSuchElementException();
            }
            this.computeNext();
            return element;
        }

        private void computeNext() {
            if (this.methodEntries.hasNext()) {
                MethodEntry methodEntry = this.methodEntries.next();
                while (this.methodEntries.hasNext() && methodEntry.getMethod() == null) {
                    methodEntry = this.methodEntries.next();
                }
                this.nextElement = methodEntry.getMethod();
            } else {
                this.nextElement = null;
            }
        }
    }
}

