/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.mutex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.collections.ConcurrentOperations;
import org.truffleruby.collections.Memo;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.mutex.MutexOperations;
import org.truffleruby.core.mutex.RubyConditionVariable;
import org.truffleruby.core.mutex.RubyMutex;
import org.truffleruby.core.thread.RubyThread;
import org.truffleruby.language.Nil;
import org.truffleruby.language.objects.AllocationTracing;

@CoreModule(value="ConditionVariable", isClass=true)
public abstract class ConditionVariableNodes {

    @CoreMethod(names={"broadcast"})
    public static abstract class BroadCastNode
    extends CoreMethodArrayArgumentsNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyConditionVariable broadcast(RubyConditionVariable self) {
            ReentrantLock condLock = self.lock;
            Condition condition = self.condition;
            condLock.lock();
            try {
                if (self.waiters > 0) {
                    self.signals += self.waiters;
                    condition.signalAll();
                }
            }
            finally {
                condLock.unlock();
            }
            return self;
        }
    }

    @CoreMethod(names={"signal"})
    public static abstract class SignalNode
    extends CoreMethodArrayArgumentsNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyConditionVariable signal(RubyConditionVariable self) {
            ReentrantLock condLock = self.lock;
            Condition condition = self.condition;
            condLock.lock();
            try {
                if (self.waiters > 0) {
                    ++self.signals;
                    condition.signal();
                }
            }
            finally {
                condLock.unlock();
            }
            return self;
        }
    }

    @Primitive(name="condition_variable_wait")
    public static abstract class WaitNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyConditionVariable noTimeout(RubyConditionVariable condVar, RubyMutex mutex, Nil timeout, @Cached.Shared @Cached InlinedBranchProfile errorProfile) {
            RubyThread thread = this.getLanguage().getCurrentThread();
            ReentrantLock mutexLock = mutex.lock;
            MutexOperations.checkOwnedMutex(this.getContext(), mutexLock, this, errorProfile);
            this.waitInternal(condVar, mutexLock, thread, -1L);
            return condVar;
        }

        @Specialization
        RubyConditionVariable withTimeout(RubyConditionVariable condVar, RubyMutex mutex, long timeout, @Cached.Shared @Cached InlinedBranchProfile errorProfile) {
            RubyThread thread = this.getLanguage().getCurrentThread();
            ReentrantLock mutexLock = mutex.lock;
            MutexOperations.checkOwnedMutex(this.getContext(), mutexLock, this, errorProfile);
            this.waitInternal(condVar, mutexLock, thread, timeout);
            return condVar;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        @SuppressFBWarnings(value={"UL_UNRELEASED_LOCK", "UL_UNRELEASED_LOCK_EXCEPTION_PATH"})
        private void waitInternal(RubyConditionVariable conditionVariable, ReentrantLock mutexLock, RubyThread thread, long durationInNanos) {
            ReentrantLock condLock = conditionVariable.lock;
            Condition condition = conditionVariable.condition;
            long endNanoTime = durationInNanos >= 0L ? System.nanoTime() + durationInNanos : 0L;
            thread.wakeUp.set(false);
            condLock.lock();
            int holdCount = 0;
            try {
                while (mutexLock.isHeldByCurrentThread()) {
                    mutexLock.unlock();
                    ++holdCount;
                }
                ++conditionVariable.waiters;
                try {
                    this.awaitSignal(conditionVariable, thread, durationInNanos, condLock, condition, endNanoTime);
                }
                catch (Error | RuntimeException e) {
                    this.consumeSignal(conditionVariable);
                    throw e;
                }
                finally {
                    --conditionVariable.waiters;
                }
            }
            finally {
                condLock.unlock();
                MutexOperations.internalLockEvenWithException(this.getContext(), mutexLock, this);
                if (holdCount > 1) {
                    for (int i = 1; i < holdCount; ++i) {
                        mutexLock.lock();
                    }
                }
            }
        }

        private void awaitSignal(RubyConditionVariable self, RubyThread thread, long durationInNanos, ReentrantLock condLock, Condition condition, long endNanoTime) {
            Memo<Boolean> done = new Memo<Boolean>(false);
            this.getContext().getThreadManager().runUntilResult(this, () -> {
                if (((Boolean)done.get()).booleanValue()) {
                    return true;
                }
                do {
                    if (durationInNanos >= 0L) {
                        long currentTime = System.nanoTime();
                        if (currentTime >= endNanoTime) {
                            return true;
                        }
                        ConcurrentOperations.awaitAndCheckInterrupt(condition, endNanoTime - currentTime, TimeUnit.NANOSECONDS);
                        continue;
                    }
                    ConcurrentOperations.awaitAndCheckInterrupt(condition);
                } while (!this.consumeSignal(self));
                return true;
            }, condLock::unlock, t -> {
                condLock.lock();
                if (thread.wakeUp.getAndSet(false)) {
                    done.set(true);
                    return;
                }
                if (this.consumeSignal(self)) {
                    done.set(true);
                }
            });
        }

        private boolean consumeSignal(RubyConditionVariable self) {
            if (self.signals > 0) {
                --self.signals;
                return true;
            }
            return false;
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyConditionVariable allocate(RubyClass rubyClass) {
            ReentrantLock condLock = MutexOperations.newReentrantLock();
            Condition condition = MutexOperations.newCondition(condLock);
            Shape shape = this.getLanguage().conditionVariableShape;
            RubyConditionVariable instance = new RubyConditionVariable(rubyClass, shape, condLock, condition);
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }
}

