/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.mutex;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.truffleruby.RubyContext;
import org.truffleruby.core.exception.ExceptionOperations;
import org.truffleruby.core.thread.RubyThread;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.RaiseException;

public abstract class MutexOperations {
    @CompilerDirectives.TruffleBoundary
    public static void lock(RubyContext context, ReentrantLock lock, RubyThread thread, RubyNode currentNode) {
        MutexOperations.lockInternal(context, lock, currentNode);
        thread.ownedLocks.add(lock);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean tryLock(ReentrantLock lock, RubyThread thread) {
        if (lock.tryLock()) {
            thread.ownedLocks.add(lock);
            return true;
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public static void lockInternal(RubyContext context, ReentrantLock lock, Node currentNode) {
        if (lock.tryLock()) {
            return;
        }
        context.getThreadManager().runUntilResult(currentNode, () -> {
            lock.lockInterruptibly();
            return true;
        });
        if (!lock.isHeldByCurrentThread()) {
            throw CompilerDirectives.shouldNotReachHere((String)"lockInternal() did not acquire lock as expected");
        }
    }

    @CompilerDirectives.TruffleBoundary
    protected static void lockEvenWithExceptions(RubyContext context, ReentrantLock lock, RubyThread thread, Node currentNode) {
        MutexOperations.internalLockEvenWithException(context, lock, currentNode);
        thread.ownedLocks.add(lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public static void internalLockEvenWithException(RubyContext context, ReentrantLock lock, Node currentNode) {
        if (lock.isHeldByCurrentThread()) {
            throw new RaiseException(context, context.getCoreExceptions().threadErrorRecursiveLocking(currentNode));
        }
        if (lock.tryLock()) {
            return;
        }
        Throwable throwable = null;
        try {
            while (true) {
                try {
                    context.getThreadManager().runUntilResult(currentNode, () -> {
                        lock.lockInterruptibly();
                        return true;
                    });
                }
                catch (Throwable t) {
                    throwable = t;
                    continue;
                }
                break;
            }
        }
        finally {
            if (!lock.isHeldByCurrentThread()) {
                throw CompilerDirectives.shouldNotReachHere((String)"the lock could not be reacquired", (Throwable)throwable);
            }
        }
        if (throwable != null) {
            ExceptionOperations.rethrow(throwable);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static void unlock(ReentrantLock lock, RubyThread thread) {
        MutexOperations.unlockInternal(lock);
        thread.ownedLocks.remove(lock);
    }

    @CompilerDirectives.TruffleBoundary
    public static void unlockInternal(ReentrantLock lock) {
        if (!lock.isHeldByCurrentThread()) {
            throw CompilerDirectives.shouldNotReachHere((String)"the lock was not held when calling unlockInternal()");
        }
        lock.unlock();
    }

    @CompilerDirectives.TruffleBoundary
    public static ReentrantLock newReentrantLock() {
        return new ReentrantLock();
    }

    @CompilerDirectives.TruffleBoundary
    public static Condition newCondition(ReentrantLock lock) {
        return lock.newCondition();
    }

    public static void checkOwnedMutex(RubyContext context, ReentrantLock lock, RubyNode currentNode, InlinedBranchProfile errorProfile) {
        if (!lock.isHeldByCurrentThread()) {
            errorProfile.enter((Node)currentNode);
            if (!lock.isLocked()) {
                throw new RaiseException(context, context.getCoreExceptions().threadErrorUnlockNotLocked(currentNode));
            }
            throw new RaiseException(context, context.getCoreExceptions().threadErrorAlreadyLocked(currentNode));
        }
    }
}

