/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.numeric;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.cast.FloatToIntegerNode;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.numeric.BigIntegerOps;
import org.truffleruby.core.numeric.FloatNodesFactory;
import org.truffleruby.core.numeric.GeneralDivModNode;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.core.thread.RubyThread;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;

@CoreModule(value="Float", isClass=true)
public abstract class FloatNodes {
    private static double findClosest(double n, double s, double d) {
        while (true) {
            double n2 = d > 0.5 ? Math.nextAfter(n, n + s) : Math.nextAfter(n, n - s);
            double f = n2 % 1.0 * s;
            double d2 = f % 1.0;
            double d3 = d > 0.5 ? 1.0 - d : d;
            double d4 = d2 > 0.5 ? 1.0 - d2 : d2;
            if (d3 < d4) {
                return n;
            }
            if ((d > 0.5 ? 1.0 - d : d) == (d2 > 0.5 ? 1.0 - d2 : d2)) {
                return Math.abs(n) < Math.abs(n2) ? n : n2;
            }
            d = d2;
            n = n2;
        }
    }

    @CoreMethod(names={"dtoa"}, visibility=Visibility.PRIVATE)
    public static abstract class DToANode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray dToA(double value) {
            int decimal;
            String string = StringUtils.format(Locale.ENGLISH, "%.1022f", value);
            if (string.toLowerCase(Locale.ENGLISH).contains("e")) {
                throw new UnsupportedOperationException();
            }
            string = StringUtils.replace(string, "-", "");
            while (string.charAt(string.length() - 1) == '0') {
                string = string.substring(0, string.length() - 1);
            }
            if (string.startsWith("0.")) {
                string = StringUtils.replace(string, "0.", "");
                decimal = 0;
                while (string.charAt(0) == '0') {
                    string = string.substring(1, string.length());
                    --decimal;
                }
            } else {
                decimal = string.indexOf(46);
                if (decimal == -1) {
                    throw new UnsupportedOperationException();
                }
                string = StringUtils.replace(string, ".", "");
            }
            int sign = value < 0.0 ? 1 : 0;
            return this.createArray(new Object[]{this.createString(this.fromJavaStringNode, string, Encodings.UTF_8), decimal, sign, string.length()});
        }
    }

    @CoreMethod(names={"to_s", "inspect"})
    @ImportStatic(value={Double.class})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @Specialization(guards={"value == POSITIVE_INFINITY"})
        RubyString toSPositiveInfinity(double value, @Cached(value="specialValueString(POSITIVE_INFINITY)") TruffleString cachedString) {
            return this.createString(cachedString, Encodings.US_ASCII);
        }

        @Specialization(guards={"value == NEGATIVE_INFINITY"})
        RubyString toSNegativeInfinity(double value, @Cached(value="specialValueString(NEGATIVE_INFINITY)") TruffleString cachedString) {
            return this.createString(cachedString, Encodings.US_ASCII);
        }

        @Specialization(guards={"isNaN(value)"})
        RubyString toSNaN(double value, @Cached(value="specialValueString(value)") TruffleString cachedString) {
            return this.createString(cachedString, Encodings.US_ASCII);
        }

        @Specialization(guards={"hasNoExp(value)"})
        RubyString toSNoExp(double value) {
            return this.createString(this.fromJavaStringNode, this.makeStringNoExp(value, this.getLanguage().getCurrentThread()), Encodings.US_ASCII);
        }

        @Specialization(guards={"hasLargeExp(value)"})
        RubyString toSLargeExp(double value) {
            return this.createString(this.fromJavaStringNode, this.makeStringLargeExp(value, this.getLanguage().getCurrentThread()), Encodings.US_ASCII);
        }

        @Specialization(guards={"hasSmallExp(value)"})
        RubyString toSSmallExp(double value) {
            return this.createString(this.fromJavaStringNode, this.makeStringSmallExp(value, this.getLanguage().getCurrentThread()), Encodings.US_ASCII);
        }

        @CompilerDirectives.TruffleBoundary
        private String makeStringNoExp(double value, RubyThread thread) {
            return this.getNoExpFormat(thread).format(value);
        }

        @CompilerDirectives.TruffleBoundary
        private String makeStringSmallExp(double value, RubyThread thread) {
            return this.getSmallExpFormat(thread).format(value);
        }

        @CompilerDirectives.TruffleBoundary
        private String makeStringLargeExp(double value, RubyThread thread) {
            return this.getLargeExpFormat(thread).format(value);
        }

        protected static boolean hasNoExp(double value) {
            double abs = Math.abs(value);
            return abs == 0.0 || abs >= 1.0E-4 && abs < 1.0E15;
        }

        protected static boolean hasLargeExp(double value) {
            double abs = Math.abs(value);
            return Double.isFinite(abs) && abs >= 1.0E15;
        }

        protected static boolean hasSmallExp(double value) {
            double abs = Math.abs(value);
            return abs < 1.0E-4 && abs != 0.0;
        }

        @NeverDefault
        protected static TruffleString specialValueString(double value) {
            return TStringUtils.fromJavaString(Double.toString(value), Encodings.US_ASCII);
        }

        private DecimalFormat getNoExpFormat(RubyThread thread) {
            if (thread.noExpFormat == null) {
                DecimalFormatSymbols noExpSymbols = new DecimalFormatSymbols(Locale.ENGLISH);
                thread.noExpFormat = new DecimalFormat("0.0################", noExpSymbols);
            }
            return thread.noExpFormat;
        }

        private DecimalFormat getSmallExpFormat(RubyThread thread) {
            if (thread.smallExpFormat == null) {
                DecimalFormatSymbols smallExpSymbols = new DecimalFormatSymbols(Locale.ENGLISH);
                smallExpSymbols.setExponentSeparator("e");
                thread.smallExpFormat = new DecimalFormat("0.0################E00", smallExpSymbols);
            }
            return thread.smallExpFormat;
        }

        private DecimalFormat getLargeExpFormat(RubyThread thread) {
            if (thread.largeExpFormat == null) {
                DecimalFormatSymbols largeExpSymbols = new DecimalFormatSymbols(Locale.ENGLISH);
                largeExpSymbols.setExponentSeparator("e+");
                thread.largeExpFormat = new DecimalFormat("0.0################E00", largeExpSymbols);
            }
            return thread.largeExpFormat;
        }
    }

    @CoreMethod(names={"to_f"})
    public static abstract class ToFNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        double toF(double value) {
            return value;
        }
    }

    @CoreMethod(names={"to_i", "to_int"})
    public static abstract class ToINode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object toI(double value, @Cached FloatToIntegerNode floatToIntegerNode) {
            return floatToIntegerNode.execute(this, value);
        }
    }

    @Primitive(name="float_exp")
    public static abstract class FloatExpNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        int exp(double value) {
            return Math.getExponent(value);
        }
    }

    @Primitive(name="float_round_down_decimal", lowerFixnum={1})
    @ImportStatic(value={FloatRoundGuards.class})
    public static abstract class FloatRoundDownDecimalPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        double roundNDecimal(double n, int ndigits, @Cached InlinedConditionProfile boundaryCase) {
            long intPart = (long)n;
            double s = Math.pow(10.0, ndigits) * Math.signum(n);
            double f = n % 1.0 * s;
            long fInt = (long)f;
            double d = f % 1.0;
            int limit = Math.getExponent(n) + Math.getExponent(s) - 51;
            if (boundaryCase.profile((Node)this, Math.getExponent(d) <= limit || Math.getExponent(1.0 - d) <= limit)) {
                return FloatNodes.findClosest(n, s, d);
            }
            if (d > 0.5 && Math.abs(n) - Math.abs((double)intPart + ((double)fInt + 0.5) / s) > 0.0) {
                ++fInt;
            }
            return (double)intPart + (double)fInt / s;
        }
    }

    @Primitive(name="float_round_down")
    @ImportStatic(value={FloatRoundGuards.class})
    public static abstract class FloatRoundDownPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"fitsInInteger(n)"})
        int roundFittingInt(double n) {
            int l = (int)n;
            int signum = (int)Math.signum(n);
            double d = Math.abs(n - (double)l);
            if (d > 0.5) {
                l += signum;
            }
            return l;
        }

        @Specialization(guards={"fitsInLong(n)"}, replaces={"roundFittingInt"})
        long roundFittingLong(double n) {
            long l = (long)n;
            long signum = (long)Math.signum(n);
            double d = Math.abs(n - (double)l);
            if (d > 0.5) {
                l += signum;
            }
            return l;
        }

        @Specialization(replaces={"roundFittingLong"})
        Object round(double n, @Cached FloatToIntegerNode floatToIntegerNode) {
            double signum = Math.signum(n);
            double f = Math.floor(Math.abs(n));
            double d = Math.abs(n) - f;
            if (d > 0.5) {
                f += 1.0;
            }
            return floatToIntegerNode.execute(this, f * signum);
        }
    }

    @Primitive(name="float_round_even_decimal", lowerFixnum={1})
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
    @ImportStatic(value={FloatRoundGuards.class})
    public static abstract class FloatRoundEvenDecimalPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        double roundNDecimal(double n, int ndigits, @Cached InlinedConditionProfile boundaryCase) {
            long intPart = (long)n;
            double s = Math.pow(10.0, ndigits) * Math.signum(n);
            double f = n % 1.0 * s;
            long fInt = (long)f;
            double d = f % 1.0;
            int limit = Math.getExponent(n) + Math.getExponent(s) - 51;
            if (boundaryCase.profile((Node)this, Math.getExponent(d) <= limit || Math.getExponent(1.0 - d) <= limit)) {
                return FloatNodes.findClosest(n, s, d);
            }
            if (d > 0.5) {
                ++fInt;
            } else if (d == 0.5 || Math.abs(n) - Math.abs((double)intPart + ((double)fInt + 0.5) / s) >= 0.0) {
                fInt += fInt % 2L;
            }
            return (double)intPart + (double)fInt / s;
        }
    }

    @Primitive(name="float_round_even")
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
    @ImportStatic(value={FloatRoundGuards.class})
    public static abstract class FloatRoundEvenPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"fitsInInteger(n)"})
        int roundFittingInt(double n) {
            int l = (int)n;
            int signum = (int)Math.signum(n);
            double d = Math.abs(n - (double)l);
            if (d > 0.5) {
                l += signum;
            } else if (d == 0.5) {
                l += l % 2;
            }
            return l;
        }

        @Specialization(guards={"fitsInLong(n)"}, replaces={"roundFittingInt"})
        long roundFittingLong(double n) {
            long l = (long)n;
            long signum = (long)Math.signum(n);
            double d = Math.abs(n - (double)l);
            if (d > 0.5) {
                l += signum;
            } else if (d == 0.5) {
                l += l % 2L;
            }
            return l;
        }

        @Specialization(replaces={"roundFittingLong"})
        Object round(double n, @Cached FloatToIntegerNode floatToIntegerNode) {
            double signum = Math.signum(n);
            double f = Math.floor(Math.abs(n));
            double d = Math.abs(n) - f;
            if (d > 0.5) {
                f += signum;
            } else if (d == 0.5) {
                f += f % 2.0;
            }
            return floatToIntegerNode.execute(this, f * signum);
        }
    }

    @Primitive(name="float_round_up_decimal", lowerFixnum={1})
    @ImportStatic(value={FloatRoundGuards.class})
    public static abstract class FloatRoundUpDecimalPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        double roundNDecimal(double n, int ndigits, @Cached InlinedConditionProfile boundaryCase) {
            long intPart = (long)n;
            double s = Math.pow(10.0, ndigits) * Math.signum(n);
            double f = n % 1.0 * s;
            long fInt = (long)f;
            double d = f % 1.0;
            int limit = Math.getExponent(n) + Math.getExponent(s) - 51;
            if (boundaryCase.profile((Node)this, Math.getExponent(d) <= limit || Math.getExponent(1.0 - d) <= limit)) {
                return FloatNodes.findClosest(n, s, d);
            }
            if (d > 0.5 || Math.abs(n) - Math.abs((double)intPart + ((double)fInt + 0.5) / s) >= 0.0) {
                ++fInt;
            }
            return (double)intPart + (double)fInt / s;
        }
    }

    @Primitive(name="float_round_up")
    @ImportStatic(value={FloatRoundGuards.class})
    public static abstract class FloatRoundUpPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"fitsInInteger(n)"})
        int roundFittingInt(double n) {
            int l = (int)n;
            int signum = (int)Math.signum(n);
            double d = Math.abs(n - (double)l);
            if (d >= 0.5) {
                l += signum;
            }
            return l;
        }

        @Specialization(guards={"fitsInLong(n)"}, replaces={"roundFittingInt"})
        long roundFittingLong(double n) {
            long l = (long)n;
            long signum = (long)Math.signum(n);
            double d = Math.abs(n - (double)l);
            if (d >= 0.5) {
                l += signum;
            }
            return l;
        }

        @Specialization(replaces={"roundFittingLong"})
        Object round(double n, @Cached FloatToIntegerNode floatToIntegerNode) {
            double signum = Math.signum(n);
            double f = Math.floor(Math.abs(n));
            double d = Math.abs(n) - f;
            if (d >= 0.5) {
                f += 1.0;
            }
            return floatToIntegerNode.execute(this, f * signum);
        }
    }

    @Primitive(name="float_floor_ndigits", lowerFixnum={1})
    public static abstract class FloatFloorNDigitsPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        double floorNDigits(double n, int ndigits) {
            double scale = Math.pow(10.0, ndigits);
            return Math.floor(n * scale) / scale;
        }
    }

    @Primitive(name="float_floor")
    public static abstract class FloatFloorPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object floor(double n, @Cached FloatToIntegerNode floatToIntegerNode) {
            return floatToIntegerNode.execute(this, Math.floor(n));
        }
    }

    @Primitive(name="float_ceil_ndigits", lowerFixnum={1})
    public static abstract class FloatCeilNDigitsPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        double ceilNDigits(double n, int ndigits) {
            double scale = Math.pow(10.0, ndigits);
            return Math.ceil(n * scale) / scale;
        }
    }

    @Primitive(name="float_ceil")
    public static abstract class FloatCeilPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object ceil(double n, @Cached FloatToIntegerNode floatToIntegerNode) {
            return floatToIntegerNode.execute(this, Math.ceil(n));
        }
    }

    protected static final class FloatRoundGuards {
        protected FloatRoundGuards() {
        }

        public static boolean fitsInInteger(double n) {
            return -2.147483648E9 < n && n < 2.147483647E9;
        }

        public static boolean fitsInLong(double n) {
            return -9.223372036854776E18 < n && n < 9.223372036854776E18;
        }
    }

    @CoreMethod(names={"prev_float"})
    public static abstract class PrevFloatNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        double prevFloat(double value) {
            return Math.nextDown(value);
        }
    }

    @CoreMethod(names={"next_float"})
    public static abstract class NextFloatNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        double nextFloat(double value) {
            return Math.nextUp(value);
        }
    }

    @CoreMethod(names={"nan?"})
    public static abstract class NaNNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean nan(double value) {
            return Double.isNaN(value);
        }
    }

    @CoreMethod(names={"infinite?"})
    public static abstract class InfiniteNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object infinite(double value) {
            if (Double.isInfinite(value)) {
                if (value < 0.0) {
                    return -1;
                }
                return 1;
            }
            return nil;
        }
    }

    @CoreMethod(names={"abs", "magnitude"})
    public static abstract class AbsNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        double abs(double n) {
            return Math.abs(n);
        }
    }

    @CoreMethod(names={">"}, required=1)
    public static abstract class GreaterNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean greater(double a, long b) {
            return a > (double)b;
        }

        @Specialization
        boolean greater(double a, double b) {
            return a > b;
        }

        @Specialization
        boolean greater(double a, RubyBignum b) {
            return BigIntegerOps.greater(a, b);
        }

        @Specialization(guards={"!isRubyNumber(b)"})
        Object greaterCoerced(double a, Object b, @Cached DispatchNode redoCompare) {
            return redoCompare.call(a, "redo_compare", this.coreSymbols().GREATER_THAN, b);
        }
    }

    @CoreMethod(names={">="}, required=1)
    public static abstract class GreaterEqualNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean greaterEqual(double a, long b) {
            return a >= (double)b;
        }

        @Specialization
        boolean greaterEqual(double a, double b) {
            return a >= b;
        }

        @Specialization
        boolean greaterEqual(double a, RubyBignum b) {
            return BigIntegerOps.greaterEqual(a, b);
        }

        @Specialization(guards={"!isRubyNumber(b)"})
        Object greaterEqualCoerced(double a, Object b, @Cached DispatchNode redoCompare) {
            return redoCompare.call(a, "redo_compare", this.coreSymbols().GEQ, b);
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isNaN(a)"})
        Object compareFirstNaN(double a, Object b) {
            return nil;
        }

        @Specialization(guards={"isNaN(b)"})
        Object compareSecondNaN(Object a, double b) {
            return nil;
        }

        @Specialization(guards={"!isNaN(a)", "!isNaN(b)"})
        int compareDoubleDouble(double a, double b, @Cached.Shared @Cached InlinedConditionProfile equalProfile) {
            return CompareNode.compareDoubles(a, b, equalProfile, this);
        }

        @Specialization(guards={"!isNaN(a)"})
        int compareDoubleLong(double a, long b, @Cached.Shared @Cached InlinedConditionProfile equalProfile) {
            return CompareNode.compareDoubles(a, b, equalProfile, this);
        }

        @Specialization(guards={"!isNaN(a)"})
        int compareBignum(double a, RubyBignum b) {
            return BigIntegerOps.compare(a, b.value);
        }

        @Specialization(guards={"!isNaN(a)", "!isRubyNumber(b)"})
        Object compare(double a, Object b, @Cached DispatchNode redoCompare) {
            return redoCompare.call((Object)a, "redo_compare_bad_coerce_return_error", b);
        }

        public static int compareDoubles(double a, double b, InlinedConditionProfile equalProfile, Node node) {
            if (equalProfile.profile(node, a == b)) {
                return 0;
            }
            return a > b ? 1 : -1;
        }
    }

    @CoreMethod(names={"==", "==="}, required=1)
    public static abstract class EqualNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private DispatchNode fallbackCallNode;

        @Specialization
        boolean equal(double a, long b) {
            return a == (double)b;
        }

        @Specialization
        boolean equal(double a, double b) {
            return a == b;
        }

        @Specialization
        boolean equal(double a, RubyBignum b) {
            return BigIntegerOps.equal(a, b);
        }

        @Specialization(guards={"!isRubyNumber(b)"})
        Object equal(VirtualFrame frame, double a, Object b) {
            if (this.fallbackCallNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.fallbackCallNode = (DispatchNode)this.insert(DispatchNode.create());
            }
            return this.fallbackCallNode.call((Object)a, "equal_fallback", b);
        }
    }

    @CoreMethod(names={"eql?"}, required=1)
    public static abstract class EqlNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean eql(double a, double b) {
            return a == b;
        }

        @Specialization(guards={"!isDouble(b)"})
        boolean eqlGeneral(double a, Object b) {
            return false;
        }
    }

    @CoreMethod(names={"<="}, required=1)
    public static abstract class LessEqualNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean lessEqual(double a, long b) {
            return a <= (double)b;
        }

        @Specialization
        boolean lessEqual(double a, double b) {
            return a <= b;
        }

        @Specialization
        boolean lessEqual(double a, RubyBignum b) {
            return BigIntegerOps.lessEqual(a, b);
        }

        @Specialization(guards={"!isRubyNumber(b)"})
        Object lessEqualCoerced(double a, Object b, @Cached DispatchNode redoCompare) {
            return redoCompare.call(a, "redo_compare", this.coreSymbols().LEQ, b);
        }
    }

    @CoreMethod(names={"<"}, required=1)
    public static abstract class LessNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean less(double a, long b) {
            return a < (double)b;
        }

        @Specialization
        boolean less(double a, double b) {
            return a < b;
        }

        @Specialization
        boolean lessBignum(double a, RubyBignum b) {
            return BigIntegerOps.less(a, b);
        }

        @Specialization(guards={"!isRubyNumber(b)"})
        Object lessCoerced(double a, Object b, @Cached DispatchNode redoCompare) {
            return redoCompare.call(a, "redo_compare", this.coreSymbols().LESS_THAN, b);
        }
    }

    @CoreMethod(names={"divmod"}, required=1)
    public static abstract class DivModNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyArray divMod(double a, long b, @Cached @Cached.Shared GeneralDivModNode divModNode) {
            return divModNode.execute(this, a, b);
        }

        @Specialization
        RubyArray divMod(double a, double b, @Cached @Cached.Shared GeneralDivModNode divModNode) {
            return divModNode.execute(this, a, b);
        }

        @Specialization
        RubyArray divMod(double a, RubyBignum b, @Cached @Cached.Shared GeneralDivModNode divModNode) {
            return divModNode.execute(this, a, b.value);
        }

        @Specialization
        Object divModCoerced(double a, RubyDynamicObject b, @Cached DispatchNode redoCoerced) {
            return redoCoerced.call(a, "redo_coerced", this.coreSymbols().DIVMOD, (Object)b);
        }
    }

    @CoreMethod(names={"%"}, required=1)
    public static abstract class ModNode
    extends CoreMethodArrayArgumentsNode {
        private final ConditionProfile lessThanZeroProfile = ConditionProfile.create();
        private final BranchProfile zeroProfile = BranchProfile.create();

        @NeverDefault
        public static ModNode create() {
            return FloatNodesFactory.ModNodeFactory.create(null);
        }

        public abstract Object executeMod(double var1, double var3);

        @Specialization
        double mod(double a, long b) {
            return this.mod(a, (double)b);
        }

        @Specialization
        double mod(double a, double b) {
            if (b == 0.0) {
                this.zeroProfile.enter();
                throw new RaiseException(this.getContext(), this.coreExceptions().zeroDivisionError(this));
            }
            double result = Math.IEEEremainder(a, b);
            if (this.lessThanZeroProfile.profile(b * result < 0.0)) {
                result += b;
            }
            return result;
        }

        @Specialization
        double mod(double a, RubyBignum b) {
            return this.mod(a, BigIntegerOps.doubleValue(b));
        }

        @Specialization(guards={"!isRubyNumber(b)"})
        Object modCoerced(double a, Object b, @Cached DispatchNode redoCoerced) {
            return redoCoerced.call(a, "redo_coerced", this.coreSymbols().MODULO, b);
        }
    }

    @CoreMethod(names={"/"}, required=1)
    public static abstract class DivNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        double div(double a, long b) {
            return a / (double)b;
        }

        @Specialization
        double div(double a, double b) {
            return a / b;
        }

        @Specialization
        double div(double a, RubyBignum b) {
            return a / BigIntegerOps.doubleValue(b);
        }

        @Specialization(guards={"!isRubyNumber(b)"})
        Object divCoerced(double a, Object b, @Cached DispatchNode redoCoerced) {
            return redoCoerced.call(a, "redo_coerced", this.coreSymbols().DIVIDE, b);
        }
    }

    @CoreMethod(names={"**"}, required=1)
    public static abstract class PowNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private DispatchNode complexConvertNode;
        @Node.Child
        private DispatchNode complexPowNode;
        private final ConditionProfile complexProfile = ConditionProfile.create();

        @Specialization(guards={"exponent == cachedExponent", "cachedExponent >= 0", "cachedExponent < 10"}, limit="10")
        @ExplodeLoop
        double powCached(double base, long exponent, @Cached(value="exponent") long cachedExponent) {
            double result = 1.0;
            int i = 0;
            while ((long)i < cachedExponent) {
                result *= base;
                ++i;
            }
            return result;
        }

        @Specialization(replaces={"powCached"})
        double pow(double base, long exponent) {
            return Math.pow(base, exponent);
        }

        @Specialization
        Object pow(VirtualFrame frame, double base, double exponent) {
            if (this.complexProfile.profile(base < 0.0 && exponent != (double)Math.round(exponent))) {
                if (this.complexConvertNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.complexConvertNode = (DispatchNode)this.insert(DispatchNode.create());
                    this.complexPowNode = (DispatchNode)this.insert(DispatchNode.create());
                }
                Object aComplex = this.complexConvertNode.call(this.coreLibrary().complexClass, "convert", base, (Object)0);
                return this.complexPowNode.call(aComplex, "**", exponent);
            }
            return Math.pow(base, exponent);
        }

        @Specialization
        double pow(double base, RubyBignum exponent) {
            return Math.pow(base, BigIntegerOps.doubleValue(exponent));
        }

        @Specialization(guards={"!isRubyNumber(exponent)"})
        Object powCoerced(double base, Object exponent, @Cached DispatchNode redoCoerced) {
            return redoCoerced.call(base, "redo_coerced", this.coreSymbols().POW, exponent);
        }
    }

    @CoreMethod(names={"*"}, required=1)
    public static abstract class MulNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        double mul(double a, long b) {
            return a * (double)b;
        }

        @Specialization
        double mul(double a, double b) {
            return a * b;
        }

        @Specialization
        double mul(double a, RubyBignum b) {
            return a * BigIntegerOps.doubleValue(b);
        }

        @Specialization(guards={"!isRubyNumber(b)"})
        Object mulCoerced(double a, Object b, @Cached DispatchNode redoCoerced) {
            return redoCoerced.call(a, "redo_coerced", this.coreSymbols().MULTIPLY, b);
        }
    }

    @CoreMethod(names={"-"}, required=1)
    public static abstract class SubNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        double sub(double a, long b) {
            return a - (double)b;
        }

        @Specialization
        double sub(double a, double b) {
            return a - b;
        }

        @Specialization
        double sub(double a, RubyBignum b) {
            return a - BigIntegerOps.doubleValue(b);
        }

        @Specialization(guards={"!isRubyNumber(b)"})
        Object subCoerced(double a, Object b, @Cached DispatchNode redoCoerced) {
            return redoCoerced.call(a, "redo_coerced", this.coreSymbols().MINUS, b);
        }
    }

    @CoreMethod(names={"+"}, required=1)
    public static abstract class AddNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        double add(double a, long b) {
            return a + (double)b;
        }

        @Specialization
        double add(double a, double b) {
            return a + b;
        }

        @Specialization
        double add(double a, RubyBignum b) {
            return a + BigIntegerOps.doubleValue(b);
        }

        @Specialization(guards={"!isRubyNumber(b)"})
        Object addCoerced(double a, Object b, @Cached DispatchNode redoCoerced) {
            return redoCoerced.call(a, "redo_coerced", this.coreSymbols().PLUS, b);
        }
    }

    @CoreMethod(names={"-@"})
    public static abstract class NegNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        double neg(double value) {
            return -value;
        }
    }
}

