/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.numeric;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.truffleruby.RubyContext;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.language.ImmutableRubyObjectNotCopyable;

@ExportLibrary(value=InteropLibrary.class)
public final class RubyBignum
extends ImmutableRubyObjectNotCopyable {
    private static final BigInteger LONG_MIN_BIGINT = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger LONG_MAX_BIGINT = BigInteger.valueOf(Long.MAX_VALUE);
    public final BigInteger value;

    public RubyBignum(BigInteger value) {
        assert (value.compareTo(LONG_MIN_BIGINT) < 0 || value.compareTo(LONG_MAX_BIGINT) > 0) : "Bignum in long range : " + value;
        this.value = value;
    }

    @CompilerDirectives.TruffleBoundary
    private int bitLength() {
        return this.value.bitLength();
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.value.toString();
    }

    @Override
    @ExportMessage
    public String toDisplayString(boolean allowSideEffects) {
        return this.toString();
    }

    @ExportMessage
    public boolean hasMetaObject() {
        return true;
    }

    @ExportMessage
    public RubyClass getMetaObject(@CachedLibrary(value="this") InteropLibrary node) {
        return RubyContext.get((Node)node).getCoreLibrary().integerClass;
    }

    @ExportMessage
    boolean isNumber() {
        return true;
    }

    @ExportMessage
    boolean fitsInByte() {
        return this.bitLength() < 8;
    }

    @ExportMessage
    boolean fitsInShort() {
        return this.bitLength() < 16;
    }

    @ExportMessage
    boolean fitsInInt() {
        return this.bitLength() < 32;
    }

    @ExportMessage
    boolean fitsInLong() {
        return this.bitLength() < 64;
    }

    @ExportMessage
    boolean fitsInBigInteger() {
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    boolean fitsInFloat() {
        if (this.bitLength() <= 24) {
            return true;
        }
        float floatValue = this.value.floatValue();
        if (!Float.isFinite(floatValue)) {
            return false;
        }
        return new BigDecimal(floatValue).toBigIntegerExact().equals(this.value);
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    boolean fitsInDouble() {
        if (this.bitLength() <= 53) {
            return true;
        }
        double doubleValue = this.value.doubleValue();
        if (!Double.isFinite(doubleValue)) {
            return false;
        }
        return new BigDecimal(doubleValue).toBigIntegerExact().equals(this.value);
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    byte asByte() throws UnsupportedMessageException {
        try {
            return this.value.byteValueExact();
        }
        catch (ArithmeticException e) {
            throw UnsupportedMessageException.create();
        }
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    short asShort() throws UnsupportedMessageException {
        try {
            return this.value.shortValueExact();
        }
        catch (ArithmeticException e) {
            throw UnsupportedMessageException.create();
        }
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    int asInt() throws UnsupportedMessageException {
        try {
            return this.value.intValueExact();
        }
        catch (ArithmeticException e) {
            throw UnsupportedMessageException.create();
        }
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    long asLong() throws UnsupportedMessageException {
        try {
            return this.value.longValueExact();
        }
        catch (ArithmeticException e) {
            throw UnsupportedMessageException.create();
        }
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    float asFloat() throws UnsupportedMessageException {
        if (this.fitsInFloat()) {
            return this.value.floatValue();
        }
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    double asDouble() throws UnsupportedMessageException {
        if (this.fitsInDouble()) {
            return this.value.doubleValue();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    BigInteger asBigInteger() {
        return this.value;
    }
}

