/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.proc;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.function.Supplier;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.language.RubyLambdaRootNode;
import org.truffleruby.language.RubyProcRootNode;
import org.truffleruby.language.RubyRootNode;

public final class ProcCallTargets {
    @CompilerDirectives.CompilationFinal
    private RootCallTarget callTargetForProc;
    @CompilerDirectives.CompilationFinal
    private RootCallTarget callTargetForLambda;
    @CompilerDirectives.CompilationFinal
    private Supplier<RootCallTarget> altCallTargetCompiler;

    public ProcCallTargets(RootCallTarget callTargetForProc, RootCallTarget callTargetForLambda, Supplier<RootCallTarget> altCallTargetCompiler) {
        assert (callTargetForProc != null || callTargetForLambda != null);
        assert (callTargetForProc == null || this.validProcRootNode(callTargetForProc));
        assert (callTargetForLambda == null || this.validLambdaRootNode(callTargetForLambda));
        this.callTargetForProc = callTargetForProc;
        this.callTargetForLambda = callTargetForLambda;
        this.altCallTargetCompiler = altCallTargetCompiler;
    }

    public ProcCallTargets(RootCallTarget callTargetForLambda) {
        this(null, callTargetForLambda, null);
    }

    public RootCallTarget getCallTargetForProc() {
        if (this.callTargetForProc == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callTargetForProc = this.altCallTargetCompiler.get();
            this.copySplit(this.callTargetForLambda, this.callTargetForProc);
            assert (this.validProcRootNode(this.callTargetForProc));
            this.altCallTargetCompiler = null;
        }
        return this.callTargetForProc;
    }

    public RootCallTarget getCallTargetForLambda() {
        if (this.callTargetForLambda == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callTargetForLambda = this.altCallTargetCompiler.get();
            this.copySplit(this.callTargetForProc, this.callTargetForLambda);
            assert (this.validLambdaRootNode(this.callTargetForLambda));
            this.altCallTargetCompiler = null;
        }
        return this.callTargetForLambda;
    }

    public boolean hasCallTargetForProc() {
        return this.callTargetForProc != null;
    }

    public boolean hasCallTargetForLambda() {
        return this.callTargetForLambda != null;
    }

    private void copySplit(RootCallTarget src, RootCallTarget dst) {
        RubyRootNode.of(dst).setSplit(RubyRootNode.of(src).getSplit());
    }

    private boolean validProcRootNode(RootCallTarget callTarget) {
        RootNode rootNode = callTarget.getRootNode();
        assert (rootNode instanceof RubyProcRootNode) : rootNode + " " + rootNode.getClass();
        return true;
    }

    private boolean validLambdaRootNode(RootCallTarget callTarget) {
        RootNode rootNode = callTarget.getRootNode();
        assert (rootNode instanceof RubyLambdaRootNode) : rootNode + " " + rootNode.getClass();
        return true;
    }

    public String toString() {
        return StringUtils.format("ProcCallTargets(callTargetForProc = %s, callTargetForLambda = %s, altCallTargetCompiler = %s)", this.callTargetForProc, this.callTargetForLambda, this.altCallTargetCompiler);
    }
}

