/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.queue;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.truffleruby.collections.ConcurrentOperations;

public final class SizedQueue {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition canAdd = this.lock.newCondition();
    private final Condition canTake = this.lock.newCondition();
    private Object[] items;
    private int addEnd;
    private int takeEnd;
    private int capacity;
    private int size;
    private boolean closed;
    public static final Object CLOSED = new Object();

    @CompilerDirectives.TruffleBoundary
    public SizedQueue(int capacity) {
        this.capacity = capacity;
        this.items = new Object[capacity];
    }

    public int getCapacity() {
        return this.capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void changeCapacity(int capacity) {
        this.lock.lock();
        try {
            this.capacity = capacity;
            if (capacity <= this.items.length) {
                return;
            }
            Object[] newItems = new Object[capacity];
            for (int n = 0; n < this.size; ++n) {
                newItems[n] = this.items[this.takeEnd];
                ++this.takeEnd;
                if (this.takeEnd != this.items.length) continue;
                this.takeEnd = 0;
            }
            this.items = newItems;
            this.addEnd = this.size;
            this.takeEnd = 0;
            this.canAdd.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public OfferResult offer(Object item) {
        this.lock.lock();
        try {
            if (this.closed) {
                OfferResult offerResult = OfferResult.CLOSED;
                return offerResult;
            }
            if (this.size == this.capacity) {
                OfferResult offerResult = OfferResult.FULL;
                return offerResult;
            }
            this.doAdd(item);
            OfferResult offerResult = OfferResult.SUCCESS;
            return offerResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public boolean put(Object item) throws InterruptedException {
        this.lock.lock();
        try {
            while (this.size == this.capacity) {
                if (this.closed) {
                    boolean bl = false;
                    return bl;
                }
                ConcurrentOperations.awaitAndCheckInterrupt(this.canAdd);
            }
            if (this.closed) {
                boolean bl = false;
                return bl;
            }
            this.doAdd(item);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public Object put(Object item, long timeoutMilliseconds) throws InterruptedException {
        this.lock.lock();
        try {
            if (this.closed) {
                Object object = CLOSED;
                return object;
            }
            long deadline = System.currentTimeMillis() + timeoutMilliseconds;
            while (this.size == this.capacity) {
                long currentTimeout = deadline - System.currentTimeMillis();
                boolean signalled = ConcurrentOperations.awaitAndCheckInterrupt(this.canAdd, currentTimeout, TimeUnit.MILLISECONDS);
                if (!signalled) {
                    Boolean bl = false;
                    return bl;
                }
                if (!this.closed) continue;
                Object object = CLOSED;
                return object;
            }
            this.doAdd(item);
            Boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void doAdd(Object item) {
        this.items[this.addEnd] = item;
        ++this.addEnd;
        if (this.addEnd == this.items.length) {
            this.addEnd = 0;
        }
        ++this.size;
        if (this.size >= 1) {
            this.canTake.signal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public Object poll(long timeoutMilliseconds) throws InterruptedException {
        this.lock.lock();
        try {
            long deadline = System.currentTimeMillis() + timeoutMilliseconds;
            while (this.size == 0) {
                long currentTimeout = deadline - System.currentTimeMillis();
                boolean signalled = ConcurrentOperations.awaitAndCheckInterrupt(this.canTake, currentTimeout, TimeUnit.MILLISECONDS);
                if (signalled) continue;
                Object var8_7 = null;
                return var8_7;
            }
            if (this.closed) {
                Object object = CLOSED;
                return object;
            }
            Object object = this.doTake();
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Object poll() {
        this.lock.lock();
        try {
            if (this.size == 0) {
                Object var1_1 = null;
                return var1_1;
            }
            Object object = this.doTake();
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Object take() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.size == 0) {
                if (this.closed) {
                    Object object = CLOSED;
                    return object;
                }
                ConcurrentOperations.awaitAndCheckInterrupt(this.canTake);
            }
            Object object = this.doTake();
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Object doTake() {
        Object item = this.items[this.takeEnd];
        ++this.takeEnd;
        if (this.takeEnd == this.items.length) {
            this.takeEnd = 0;
        }
        --this.size;
        if (this.size < this.capacity) {
            this.canAdd.signal();
        }
        return item;
    }

    @CompilerDirectives.TruffleBoundary
    public void clear() {
        this.lock.lock();
        try {
            if (this.size != 0) {
                this.size = 0;
                this.addEnd = 0;
                this.takeEnd = 0;
                this.canAdd.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public int size() {
        this.lock.lock();
        try {
            int n = this.size;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @CompilerDirectives.TruffleBoundary
    public int getNumberWaiting() {
        this.lock.lock();
        try {
            int n = this.lock.getWaitQueueLength(this.canTake) + this.lock.getWaitQueueLength(this.canAdd);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public Collection<Object> getContents() {
        ArrayList<Object> objects = new ArrayList<Object>();
        this.lock.lock();
        try {
            int takePoint = this.takeEnd;
            for (int n = 0; n < this.size; ++n) {
                objects.add(this.items[takePoint]);
                if (++takePoint != this.items.length) continue;
                takePoint = 0;
            }
        }
        finally {
            this.lock.unlock();
        }
        return objects;
    }

    @CompilerDirectives.TruffleBoundary
    public void close() {
        this.lock.lock();
        try {
            this.closed = true;
            this.canAdd.signalAll();
            this.canTake.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isClosed() {
        this.lock.lock();
        try {
            boolean bl = this.closed;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static enum OfferResult {
        SUCCESS,
        FULL,
        CLOSED;

    }
}

