/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.refinement;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.HashMap;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.methods.DeclarationContext;
import org.truffleruby.language.methods.InternalMethod;

@CoreModule(value="Refinement", isClass=true)
public abstract class RefinementNodes {

    @CoreMethod(names={"refined_class"})
    public static abstract class RefinedClassNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyModule refinedClass(RubyModule refinement) {
            return refinement.fields.getRefinedModule();
        }
    }

    @Primitive(name="refinement_import_methods")
    public static abstract class ImportMethodsNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyModule importMethods(RubyModule refinement, RubyModule moduleToImportFrom) {
            InternalMethod firstNonRubyMethod = this.getFirstNonRubyMethodOrNull(moduleToImportFrom, this.getLanguage());
            if (firstNonRubyMethod != null) {
                throw new RaiseException(this.getContext(), this.coreExceptions().argumentError(this.createErrorMessage(firstNonRubyMethod, moduleToImportFrom), this));
            }
            this.importMethodsFromModuleToRefinement(moduleToImportFrom, refinement);
            return refinement;
        }

        private String createErrorMessage(InternalMethod method, RubyModule module) {
            return StringUtils.format("Can't import method which is not defined with Ruby code: %s#%s", module.getName(), method.getName());
        }

        private void importMethodsFromModuleToRefinement(RubyModule module, RubyModule refinement) {
            DeclarationContext declarationContext = this.createDeclarationContextWithRefinement(refinement);
            for (InternalMethod methodToCopy : module.fields.getMethods()) {
                InternalMethod clonedMethod = this.cloneMethod(methodToCopy, declarationContext, refinement);
                refinement.fields.addMethod(this.getContext(), this, clonedMethod);
            }
        }

        private InternalMethod getFirstNonRubyMethodOrNull(RubyModule module, RubyLanguage language) {
            for (InternalMethod method : module.fields.getMethods()) {
                if (method.isDefinedInRuby(language)) continue;
                return method;
            }
            return null;
        }

        private DeclarationContext createDeclarationContextWithRefinement(RubyModule refinement) {
            HashMap<RubyModule, RubyModule[]> refinements = new HashMap<RubyModule, RubyModule[]>();
            refinements.put(refinement.fields.getRefinedModule(), new RubyModule[]{refinement});
            return new DeclarationContext(Visibility.PUBLIC, new DeclarationContext.FixedDefaultDefinee(refinement), refinements);
        }

        private InternalMethod cloneMethod(InternalMethod method, DeclarationContext declarationContext, RubyModule refinement) {
            RootCallTarget clonedCallTarget = this.cloneCallTarget(method);
            return method.withCallTargetAndDeclarationContextAndDeclarationModule(clonedCallTarget, declarationContext, refinement);
        }

        private RootCallTarget cloneCallTarget(InternalMethod method) {
            RubyRootNode rubyRootNode = (RubyRootNode)method.getCallTarget().getRootNode();
            RootNode clonedRootNode = rubyRootNode.cloneUninitialized();
            return clonedRootNode.getCallTarget();
        }
    }
}

