/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.string;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.TStringUtils;

public final class PathToTStringCache {
    private final RubyLanguage language;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final WeakHashMap<String, TruffleString> javaStringToTString = new WeakHashMap();

    public PathToTStringCache(RubyLanguage language) {
        this.language = language;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public TruffleString getCachedPath(Source source) {
        String path = this.language.getSourcePath(source);
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            TruffleString tstring = this.javaStringToTString.get(path);
            if (tstring != null) {
                TruffleString truffleString = tstring;
                return truffleString;
            }
        }
        finally {
            readLock.unlock();
        }
        TruffleString cachedString = this.language.tstringCache.getTString(TStringUtils.utf8TString(path), Encodings.UTF_8);
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            this.javaStringToTString.putIfAbsent(path, cachedString);
        }
        finally {
            writeLock.unlock();
        }
        return cachedString;
    }
}

