/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.string;

import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import org.jcodings.Encoding;
import org.truffleruby.collections.ByteArrayBuilder;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.TStringWithEncoding;

public final class TStringBuilder
extends ByteArrayBuilder {
    private RubyEncoding encoding = Encodings.BINARY;

    public TStringBuilder() {
    }

    public TStringBuilder(int size) {
        super(size);
    }

    public static TStringBuilder create(int size) {
        return new TStringBuilder(size);
    }

    public static TStringBuilder create(byte[] bytes, RubyEncoding encoding) {
        TStringBuilder builder = new TStringBuilder(bytes.length);
        builder.append(bytes);
        builder.setEncoding(encoding);
        return builder;
    }

    public static TStringBuilder create(RubyString rubyString) {
        RubyEncoding enc = rubyString.getEncodingUncached();
        return TStringBuilder.create(rubyString.tstring.getInternalByteArrayUncached(enc.tencoding), enc);
    }

    public static TStringBuilder create(byte[] bytes) {
        TStringBuilder builder = new TStringBuilder(bytes.length);
        builder.append(bytes);
        return builder;
    }

    public static TStringBuilder create(byte[] bytes, int index, int len) {
        TStringBuilder builder = new TStringBuilder(len);
        builder.append(bytes, index, len);
        return builder;
    }

    public static TStringBuilder create(InternalByteArray bytes) {
        return TStringBuilder.create(bytes.getArray(), bytes.getOffset(), bytes.getLength());
    }

    public static TStringBuilder create(InternalByteArray bytes, RubyEncoding encoding) {
        TStringBuilder builder = TStringBuilder.create(bytes);
        builder.setEncoding(encoding);
        return builder;
    }

    public RubyEncoding getRubyEncoding() {
        return this.encoding;
    }

    public Encoding getEncoding() {
        return this.encoding.jcoding;
    }

    public void setEncoding(RubyEncoding encoding) {
        this.encoding = encoding;
    }

    public TruffleString toTString() {
        return TStringUtils.fromByteArray(this.getBytes(), this.encoding);
    }

    public TruffleString toTStringUnsafe(TruffleString.FromByteArrayNode fromByteArrayNode) {
        return fromByteArrayNode.execute(this.getUnsafeBytes(), 0, this.getLength(), this.encoding.tencoding, false);
    }

    public TStringWithEncoding toTStringWithEnc() {
        return new TStringWithEncoding(TStringUtils.fromByteArray(this.getBytes(), this.encoding), this.encoding);
    }
}

