/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.support;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.memory.ByteArraySupport;
import java.nio.ByteOrder;
import org.truffleruby.core.numeric.FixnumLowerNode;
import org.truffleruby.core.support.GetRandomIntNodeGen;
import org.truffleruby.core.support.RubyCustomRandomizer;
import org.truffleruby.core.support.RubyPRNGRandomizer;
import org.truffleruby.core.support.RubySecureRandomizer;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.dispatch.DispatchNode;

public abstract class GetRandomIntNode
extends RubyBaseNode {
    private static final ByteArraySupport byteArraySupport = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteArraySupport.bigEndian() : ByteArraySupport.littleEndian();

    @NeverDefault
    public static GetRandomIntNode create() {
        return GetRandomIntNodeGen.create();
    }

    public abstract int execute(Object var1);

    @Specialization
    int genRandInt(RubyPRNGRandomizer randomizer) {
        return randomizer.genrandInt32();
    }

    @Specialization
    int genRandInt(RubySecureRandomizer randomizer) {
        byte[] bytes = this.getContext().getRandomSeedBytes(4);
        return byteArraySupport.getInt(bytes, 0);
    }

    @Specialization
    int genRandFallback(RubyCustomRandomizer randomizer, @Cached DispatchNode randomIntNode, @Cached FixnumLowerNode fixnumLowerNode) {
        return (Integer)fixnumLowerNode.execute(this, randomIntNode.call((Object)this.getContext().getCoreLibrary().truffleRandomOperationsModule, "obj_random_int", (Object)randomizer));
    }
}

