/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.symbol;

import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;
import java.util.List;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.string.StringOperations;
import org.truffleruby.core.string.TStringConstants;
import org.truffleruby.core.symbol.RubySymbol;

public final class CoreSymbols {
    public static final long STATIC_SYMBOL_ID = 1L;
    private static final long GLOBAL_SYMBOL_ID = 6L;
    public static final int STATIC_SYMBOLS_SIZE = 242;
    public final List<RubySymbol> CORE_SYMBOLS = new ArrayList<RubySymbol>();
    public final RubySymbol[] STATIC_SYMBOLS = new RubySymbol[242];
    public final RubySymbol CLASS = this.createRubySymbol("class");
    public final RubySymbol NEW = this.createRubySymbol("new");
    public final RubySymbol IMMEDIATE = this.createRubySymbol("immediate");
    public final RubySymbol LINE = this.createRubySymbol("line");
    public final RubySymbol NEVER = this.createRubySymbol("never");
    public final RubySymbol ON_BLOCKING = this.createRubySymbol("on_blocking");
    public final RubySymbol DEPRECATED = this.createRubySymbol("deprecated");
    public final RubySymbol EXPERIMENTAL = this.createRubySymbol("experimental");
    public final RubySymbol PERFORMANCE = this.createRubySymbol("performance");
    public final RubySymbol BIG = this.createRubySymbol("big");
    public final RubySymbol LITTLE = this.createRubySymbol("little");
    public final RubySymbol NATIVE = this.createRubySymbol("native");
    public final RubySymbol IMMEDIATE_SWEEP = this.createRubySymbol("immediate_sweep");
    public final RubySymbol IMMEDIATE_MARK = this.createRubySymbol("immediate_mark");
    public final RubySymbol FULL_MARK = this.createRubySymbol("full_mark");
    public static final int FIRST_OP_ID = 33;
    public final RubySymbol BANG = this.createRubySymbol("!", 33L);
    public final RubySymbol DOUBLE_QUOTE = this.createRubySymbol("\"", 34L);
    public final RubySymbol POUND = this.createRubySymbol("#", 35L);
    public final RubySymbol DOLLAR = this.createRubySymbol("$", 36L);
    public final RubySymbol MODULO = this.createRubySymbol("%", 37L);
    public final RubySymbol AMPERSAND = this.createRubySymbol("&", 38L);
    public final RubySymbol SINGLE_QUOTE = this.createRubySymbol("'", 39L);
    public final RubySymbol LPAREN = this.createRubySymbol("(", 40L);
    public final RubySymbol RPAREN = this.createRubySymbol(")", 41L);
    public final RubySymbol MULTIPLY = this.createRubySymbol("*", 42L);
    public final RubySymbol PLUS = this.createRubySymbol("+", 43L);
    public final RubySymbol COMMA = this.createRubySymbol(",", 44L);
    public final RubySymbol MINUS = this.createRubySymbol("-", 45L);
    public final RubySymbol PERIOD = this.createRubySymbol(".", 46L);
    public final RubySymbol DIVIDE = this.createRubySymbol("/", 47L);
    public final RubySymbol COLON = this.createRubySymbol(":", 58L);
    public final RubySymbol SEMICOLON = this.createRubySymbol(";", 59L);
    public final RubySymbol LESS_THAN = this.createRubySymbol("<", 60L);
    public final RubySymbol EQUAL = this.createRubySymbol("=", 61L);
    public final RubySymbol GREATER_THAN = this.createRubySymbol(">", 62L);
    public final RubySymbol QUESTION_MARK = this.createRubySymbol("?", 63L);
    public final RubySymbol AT_SYMBOL = this.createRubySymbol("@", 64L);
    public final RubySymbol LEFT_BRACKET = this.createRubySymbol("[", 91L);
    public final RubySymbol BACK_SLASH = this.createRubySymbol("\\", 92L);
    public final RubySymbol RIGHT_BRACKET = this.createRubySymbol("]", 93L);
    public final RubySymbol CIRCUMFLEX = this.createRubySymbol("^", 94L);
    public final RubySymbol BACK_TICK = this.createRubySymbol("`", 96L);
    public final RubySymbol LEFT_BRACE = this.createRubySymbol("{", 123L);
    public final RubySymbol PIPE = this.createRubySymbol("|", 124L);
    public final RubySymbol RIGHT_BRACE = this.createRubySymbol("}", 125L);
    public final RubySymbol TILDE = this.createRubySymbol("~", 126L);
    public final RubySymbol DOT2 = this.createRubySymbol("..", 128L);
    public final RubySymbol DOT3 = this.createRubySymbol("...", 129L);
    public final RubySymbol UPLUS = this.createRubySymbol("+@", 132L);
    public final RubySymbol UMINUS = this.createRubySymbol("-@", 133L);
    public final RubySymbol POW = this.createRubySymbol("**", 134L);
    public final RubySymbol CMP = this.createRubySymbol("<=>", 135L);
    public final RubySymbol LSHFT = this.createRubySymbol("<<", 136L);
    public final RubySymbol RSHFT = this.createRubySymbol(">>", 137L);
    public final RubySymbol LEQ = this.createRubySymbol("<=", 138L);
    public final RubySymbol GEQ = this.createRubySymbol(">=", 139L);
    public final RubySymbol EQ = this.createRubySymbol("==", 140L);
    public final RubySymbol EQQ = this.createRubySymbol("===", 141L);
    public final RubySymbol NEQ = this.createRubySymbol("!=", 142L);
    public final RubySymbol MATCH = this.createRubySymbol("=~", 143L);
    public final RubySymbol NMATCH = this.createRubySymbol("!~", 144L);
    public final RubySymbol AREF = this.createRubySymbol("[]", 145L);
    public final RubySymbol ASET = this.createRubySymbol("[]=", 146L);
    public final RubySymbol COLON2 = this.createRubySymbol("::", 147L);
    public final RubySymbol ANDOP = this.createRubySymbol("&&", 148L);
    public final RubySymbol OROP = this.createRubySymbol("||", 149L);
    public final RubySymbol ANDDOT = this.createRubySymbol("&.", 150L);
    public final RubySymbol NILP = this.createRubySymbol("nil?", 151L);
    public final RubySymbol NULL = this.createRubySymbol("", 152L);
    public final RubySymbol EMPTYP = this.createRubySymbol("empty?", 153L);
    public final RubySymbol EQLP = this.createRubySymbol("eql?", 154L);
    public final RubySymbol RESPOND_TO = this.createRubySymbol("respond_to?", 155L);
    public final RubySymbol RESPOND_TO_MISSING = this.createRubySymbol("respond_to_missing?", 156L);
    public final RubySymbol IFUNC = this.createRubySymbol("<IFUNC>", 157L);
    public final RubySymbol CFUNC = this.createRubySymbol("<CFUNC>", 158L);
    public final RubySymbol CORE_SET_METHOD_ALIAS = this.createRubySymbol("core#set_method_alias", 159L);
    public final RubySymbol CORE_SET_VARIABLE_ALIAS = this.createRubySymbol("core#set_variable_alias", 160L);
    public final RubySymbol CORE_UNDEF_METHOD = this.createRubySymbol("core#undef_method", 161L);
    public final RubySymbol CORE_DEFINE_METHOD = this.createRubySymbol("core#define_method", 162L);
    public final RubySymbol CORE_DEFINE_SINGLETON_METHOD = this.createRubySymbol("core#define_singleton_method", 163L);
    public final RubySymbol CORE_SET_POSTEXE = this.createRubySymbol("core#set_postexe", 164L);
    public final RubySymbol CORE_HASH_MERGE_PTR = this.createRubySymbol("core#hash_merge_ptr", 165L);
    public final RubySymbol CORE_HASH_MERGE_KWD = this.createRubySymbol("core#hash_merge_kwd", 166L);
    public final RubySymbol CORE_RAISE = this.createRubySymbol("core#raise", 167L);
    public final RubySymbol CORE_SPRINTF = this.createRubySymbol("core#sprintf", 168L);
    public static final int LAST_OP_ID = 169;
    public final RubySymbol MAX = this.createRubySymbol("max", CoreSymbols.toLocal(170L));
    public final RubySymbol MIN = this.createRubySymbol("min", CoreSymbols.toLocal(171L));
    public final RubySymbol FREEZE = this.createRubySymbol("freeze", CoreSymbols.toLocal(172L));
    public final RubySymbol INSPECT = this.createRubySymbol("inspect", CoreSymbols.toLocal(173L));
    public final RubySymbol INTERN = this.createRubySymbol("intern", CoreSymbols.toLocal(174L));
    public final RubySymbol OBJECT_ID = this.createRubySymbol("object_id", CoreSymbols.toLocal(175L));
    public final RubySymbol CONST_ADDED = this.createRubySymbol("const_added", CoreSymbols.toLocal(176L));
    public final RubySymbol CONST_MISSING = this.createRubySymbol("const_missing", CoreSymbols.toLocal(177L));
    public final RubySymbol METHODMISSING = this.createRubySymbol("method_missing", CoreSymbols.toLocal(178L));
    public final RubySymbol METHOD_ADDED = this.createRubySymbol("method_added", CoreSymbols.toLocal(179L));
    public final RubySymbol SINGLETON_METHOD_ADDED = this.createRubySymbol("singleton_method_added", CoreSymbols.toLocal(180L));
    public final RubySymbol METHOD_REMOVED = this.createRubySymbol("method_removed", CoreSymbols.toLocal(181L));
    public final RubySymbol SINGLETON_METHOD_REMOVED = this.createRubySymbol("singleton_method_removed", CoreSymbols.toLocal(182L));
    public final RubySymbol METHOD_UNDEFINED = this.createRubySymbol("method_undefined", CoreSymbols.toLocal(183L));
    public final RubySymbol SINGLETON_METHOD_UNDEFINED = this.createRubySymbol("singleton_method_undefined", CoreSymbols.toLocal(184L));
    public final RubySymbol LENGTH = this.createRubySymbol("length", CoreSymbols.toLocal(185L));
    public final RubySymbol SIZE = this.createRubySymbol("size", CoreSymbols.toLocal(186L));
    public final RubySymbol GETS = this.createRubySymbol("gets", CoreSymbols.toLocal(187L));
    public final RubySymbol SUCC = this.createRubySymbol("succ", CoreSymbols.toLocal(188L));
    public final RubySymbol EACH = this.createRubySymbol("each", CoreSymbols.toLocal(189L));
    public final RubySymbol PROC = this.createRubySymbol("proc", CoreSymbols.toLocal(190L));
    public final RubySymbol LAMBDA = this.createRubySymbol("lambda", CoreSymbols.toLocal(191L));
    public final RubySymbol SEND = this.createRubySymbol("send", CoreSymbols.toLocal(192L));
    public final RubySymbol __SEND__ = this.createRubySymbol("__send__", CoreSymbols.toLocal(193L));
    public final RubySymbol __ATTACHED__ = this.createRubySymbol("__attached__", CoreSymbols.toLocal(194L));
    public final RubySymbol __RECURSIVE_KEY__ = this.createRubySymbol("__recursive_key__", CoreSymbols.toLocal(195L));
    public final RubySymbol INITIALIZE = this.createRubySymbol("initialize", CoreSymbols.toLocal(196L));
    public final RubySymbol INITIALIZE_COPY = this.createRubySymbol("initialize_copy", CoreSymbols.toLocal(197L));
    public final RubySymbol INITIALIZE_CLONE = this.createRubySymbol("initialize_clone", CoreSymbols.toLocal(198L));
    public final RubySymbol INITIALIZE_DUP = this.createRubySymbol("initialize_dup", CoreSymbols.toLocal(199L));
    public final RubySymbol TO_INT = this.createRubySymbol("to_int", CoreSymbols.toLocal(200L));
    public final RubySymbol TO_ARY = this.createRubySymbol("to_ary", CoreSymbols.toLocal(201L));
    public final RubySymbol TO_STR = this.createRubySymbol("to_str", CoreSymbols.toLocal(202L));
    public final RubySymbol TO_SYM = this.createRubySymbol("to_sym", CoreSymbols.toLocal(203L));
    public final RubySymbol TO_HASH = this.createRubySymbol("to_hash", CoreSymbols.toLocal(204L));
    public final RubySymbol TO_PROC = this.createRubySymbol("to_proc", CoreSymbols.toLocal(205L));
    public final RubySymbol TO_IO = this.createRubySymbol("to_io", CoreSymbols.toLocal(206L));
    public final RubySymbol TO_A = this.createRubySymbol("to_a", CoreSymbols.toLocal(207L));
    public final RubySymbol TO_S = this.createRubySymbol("to_s", CoreSymbols.toLocal(208L));
    public final RubySymbol TO_I = this.createRubySymbol("to_i", CoreSymbols.toLocal(209L));
    public final RubySymbol TO_F = this.createRubySymbol("to_f", CoreSymbols.toLocal(210L));
    public final RubySymbol TO_R = this.createRubySymbol("to_r", CoreSymbols.toLocal(211L));
    public final RubySymbol BT = this.createRubySymbol("bt", CoreSymbols.toLocal(212L));
    public final RubySymbol BT_LOCATIONS = this.createRubySymbol("bt_locations", CoreSymbols.toLocal(213L));
    public final RubySymbol CALL = this.createRubySymbol("call", CoreSymbols.toLocal(214L));
    public final RubySymbol MESG = this.createRubySymbol("mesg", CoreSymbols.toLocal(215L));
    public final RubySymbol EXCEPTION = this.createRubySymbol("exception", CoreSymbols.toLocal(216L));
    public final RubySymbol LOCALS = this.createRubySymbol("locals", CoreSymbols.toLocal(217L));
    public final RubySymbol NOT = this.createRubySymbol("not", CoreSymbols.toLocal(218L));
    public final RubySymbol AND = this.createRubySymbol("and", CoreSymbols.toLocal(219L));
    public final RubySymbol OR = this.createRubySymbol("or", CoreSymbols.toLocal(220L));
    public final RubySymbol DIV = this.createRubySymbol("div", CoreSymbols.toLocal(221L));
    public final RubySymbol DIVMOD = this.createRubySymbol("divmod", CoreSymbols.toLocal(222L));
    public final RubySymbol FDIV = this.createRubySymbol("fdiv", CoreSymbols.toLocal(223L));
    public final RubySymbol QUO = this.createRubySymbol("quo", CoreSymbols.toLocal(224L));
    public final RubySymbol NAME = this.createRubySymbol("name", CoreSymbols.toLocal(225L));
    public final RubySymbol NIL = this.createRubySymbol("nil", CoreSymbols.toLocal(226L));
    public final RubySymbol PATH = this.createRubySymbol("path", CoreSymbols.toLocal(227L));
    public final RubySymbol USCORE = this.createRubySymbol("_", CoreSymbols.toLocal(228L));
    public final RubySymbol NUMPARAM_1 = this.createRubySymbol("_1", CoreSymbols.toLocal(229L));
    public final RubySymbol NUMPARAM_2 = this.createRubySymbol("_2", CoreSymbols.toLocal(230L));
    public final RubySymbol NUMPARAM_3 = this.createRubySymbol("_3", CoreSymbols.toLocal(231L));
    public final RubySymbol NUMPARAM_4 = this.createRubySymbol("_4", CoreSymbols.toLocal(232L));
    public final RubySymbol NUMPARAM_5 = this.createRubySymbol("_5", CoreSymbols.toLocal(233L));
    public final RubySymbol NUMPARAM_6 = this.createRubySymbol("_6", CoreSymbols.toLocal(234L));
    public final RubySymbol NUMPARAM_7 = this.createRubySymbol("_7", CoreSymbols.toLocal(235L));
    public final RubySymbol NUMPARAM_8 = this.createRubySymbol("_8", CoreSymbols.toLocal(236L));
    public final RubySymbol NUMPARAM_9 = this.createRubySymbol("_9", CoreSymbols.toLocal(237L));
    public final RubySymbol DEFAULT = this.createRubySymbol("default", CoreSymbols.toLocal(238L));
    public final RubySymbol LASTLINE = this.createRubySymbol("$_", CoreSymbols.toGlobal(239L));
    public final RubySymbol BACKREF = this.createRubySymbol("$~", CoreSymbols.toGlobal(240L));
    public final RubySymbol ERROR_INFO = this.createRubySymbol("$!", CoreSymbols.toGlobal(241L));

    public RubySymbol createRubySymbol(String string, long id) {
        TruffleString tstring = TStringConstants.lookupUSASCIITString(string);
        if (tstring == null) {
            byte[] bytes = StringOperations.encodeAsciiBytes(string);
            tstring = TStringUtils.fromByteArray(bytes, TruffleString.Encoding.US_ASCII);
        }
        RubySymbol symbol = new RubySymbol(string, tstring, Encodings.US_ASCII, id);
        this.CORE_SYMBOLS.add(symbol);
        if (id != -1L) {
            int index = CoreSymbols.idToIndex(id);
            this.STATIC_SYMBOLS[index] = symbol;
        }
        return symbol;
    }

    public RubySymbol createRubySymbol(String string) {
        return this.createRubySymbol(string, -1L);
    }

    public static int idToIndex(long id) {
        int index = id > 169L ? (int)id >> 4 : (int)id;
        assert (index < 242);
        return index;
    }

    private static long toLocal(long id) {
        return id << 4 | 1L;
    }

    private static long toGlobal(long id) {
        return id << 4 | 1L | 6L;
    }

    public static boolean isStaticSymbol(long value) {
        return value >= 33L && value <= 169L || (value & 1L) == 1L && value >> 4 < 242L;
    }
}

