/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.symbol;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Objects;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.Hashing;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.symbol.SymbolNodes;
import org.truffleruby.language.ImmutableRubyObjectNotCopyable;
import org.truffleruby.language.methods.DeclarationContext;
import org.truffleruby.parser.IdentifierType;
import org.truffleruby.parser.Identifiers;

@ExportLibrary(value=InteropLibrary.class)
public final class RubySymbol
extends ImmutableRubyObjectNotCopyable
implements TruffleObject {
    public static final int UNASSIGNED_ID = -1;
    private static final int CLASS_SALT = 92021474;
    public final RubyEncoding encoding;
    private final String string;
    public final TruffleString tstring;
    private final int javaStringHashCode;
    private final long id;
    private ImmutableRubyString name;
    private final IdentifierType type;
    private volatile RootCallTarget callTargetNoRefinements = null;

    RubySymbol(String string, TruffleString tstring, RubyEncoding encoding, long id) {
        assert (tstring.isManaged());
        assert (tstring.isCompatibleToUncached(encoding.tencoding));
        this.encoding = Objects.requireNonNull(encoding);
        this.string = Objects.requireNonNull(string);
        this.tstring = Objects.requireNonNull(tstring);
        this.javaStringHashCode = string.hashCode();
        this.id = id;
        this.type = Identifiers.stringToType(string);
    }

    RubySymbol(String string, TruffleString tstring, RubyEncoding encoding) {
        this(string, tstring, encoding, -1L);
    }

    public long getId() {
        return this.id;
    }

    public String getString() {
        return this.string;
    }

    public IdentifierType getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public RootCallTarget getCallTargetNoRefinements(RubyLanguage language) {
        if (this.callTargetNoRefinements == null) {
            RubySymbol rubySymbol = this;
            synchronized (rubySymbol) {
                if (this.callTargetNoRefinements == null) {
                    this.callTargetNoRefinements = SymbolNodes.ToProcNode.createCallTarget(language, this, DeclarationContext.NO_REFINEMENTS);
                }
            }
        }
        return this.callTargetNoRefinements;
    }

    public long computeHashCode(Hashing hashing) {
        return hashing.hash(92021474L, this.javaStringHashCode);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return ":" + this.string;
    }

    public ImmutableRubyString getName(RubyLanguage language) {
        if (this.name == null) {
            this.name = language.getFrozenStringLiteral(this.tstring, this.encoding);
        }
        return this.name;
    }

    @Override
    @ExportMessage
    public String toDisplayString(boolean allowSideEffects) {
        return this.toString();
    }

    @ExportMessage
    public boolean hasMetaObject() {
        return true;
    }

    @ExportMessage
    public RubyClass getMetaObject(@CachedLibrary(value="this") InteropLibrary node) {
        return RubyContext.get((Node)node).getCoreLibrary().symbolClass;
    }

    @ExportMessage
    public boolean isString() {
        return true;
    }

    @ExportMessage
    public static final class AsString {
        @Specialization(guards={"symbol == cachedSymbol"}, limit="1")
        static String asStringCached(RubySymbol symbol, @Cached(value="symbol") RubySymbol cachedSymbol, @Cached(value="cachedSymbol.getString()") String cachedString) {
            return cachedString;
        }

        @Specialization(replaces={"asStringCached"})
        static String asStringUncached(RubySymbol symbol) {
            return symbol.getString();
        }
    }
}

