/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.thread;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.core.kernel.TruffleKernelNodes;
import org.truffleruby.language.threadlocal.SpecialVariableStorage;

@CoreModule(value="Truffle::ThreadOperations")
public abstract class TruffleThreadNodes {

    @CoreMethod(names={"ruby_caller_special_variables"}, onSingleton=true, required=1)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class FindRubyCallerSpecialStorage
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(limit="storageStrategyLimit()")
        static Object findRubyCaller(RubyArray modules, @Bind(value="modules.getStore()") Object store, @CachedLibrary(value="store") ArrayStoreLibrary stores, @Cached TruffleKernelNodes.GetSpecialVariableStorage storageNode, @Bind(value="this") Node node) {
            int modulesSize = modules.size;
            Object[] moduleArray = stores.boxedCopyOfRange(store, 0, modulesSize);
            MaterializedFrame frame = FindRubyCallerSpecialStorage.getContext(node).getCallStack().iterateFrameNotInModules(moduleArray, f -> f.getFrame(FrameInstance.FrameAccess.MATERIALIZE).materialize());
            if (frame == null) {
                return nil;
            }
            SpecialVariableStorage variables = storageNode.execute((Frame)frame.materialize(), node);
            FindRubyCallerSpecialStorage.getLanguage((Node)node).getCurrentFiber().extensionCallStack.setSpecialVariables(variables);
            return variables;
        }
    }
}

