/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.time;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.Shape;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyDynamicObject;

@ExportLibrary(value=InteropLibrary.class)
public final class RubyTime
extends RubyDynamicObject {
    ZonedDateTime dateTime;
    Object offset;
    Object zone;
    boolean relativeOffset;
    boolean isUtc;

    public RubyTime(RubyClass rubyClass, Shape shape, ZonedDateTime dateTime, Object zone, Object offset, boolean relativeOffset, boolean isUtc) {
        super(rubyClass, shape);
        assert (zone instanceof RubyString || zone == Nil.INSTANCE);
        this.dateTime = dateTime;
        this.offset = offset;
        this.zone = zone;
        this.relativeOffset = relativeOffset;
        this.isUtc = isUtc;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public Instant asInstant() {
        return this.dateTime.toInstant();
    }

    @ExportMessage
    public boolean isDate() {
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public LocalDate asDate() {
        return this.dateTime.toLocalDate();
    }

    @ExportMessage
    public boolean isTime() {
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public LocalTime asTime() {
        return this.dateTime.toLocalTime();
    }

    @ExportMessage
    public boolean isTimeZone() {
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public ZoneId asTimeZone() {
        return this.dateTime.getZone();
    }
}

