/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.tracepoint;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.Tag;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.core.tracepoint.RubyTracePoint;
import org.truffleruby.core.tracepoint.TracePointEventNode;

public final class TracePointEvent {
    public final Class<? extends Tag> tagClass;
    public final RubySymbol eventSymbol;
    private EventBinding<ExecutionEventNodeFactory> eventBinding;

    public TracePointEvent(Class<? extends Tag> tagClass, RubySymbol eventSymbol) {
        this.tagClass = tagClass;
        this.eventSymbol = eventSymbol;
    }

    public synchronized boolean hasEventBinding() {
        return this.eventBinding != null;
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized boolean setupEventBinding(RubyContext context, RubyLanguage language, RubyTracePoint tracePoint) {
        if (this.eventBinding != null) {
            return false;
        }
        SourceSectionFilter sourceSectionFilter = SourceSectionFilter.newBuilder().mimeTypeIs(RubyLanguage.MIME_TYPES).tagIs(new Class[]{this.tagClass}).includeInternal(false).build();
        this.eventBinding = context.getInstrumenter().attachExecutionEventFactory(sourceSectionFilter, eventContext -> new TracePointEventNode(context, language, eventContext, tracePoint, this.eventSymbol));
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized boolean diposeEventBinding() {
        if (this.eventBinding != null) {
            this.eventBinding.dispose();
            this.eventBinding = null;
            return true;
        }
        return false;
    }
}

