/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.core.binding.BindingNodes;
import org.truffleruby.core.binding.RubyBinding;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.debug.VariableNamesObject;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.parser.Identifiers;

@ExportLibrary(value=InteropLibrary.class)
public final class BindingLocalVariablesObject
implements TruffleObject {
    @CompilerDirectives.CompilationFinal
    private RubyBinding binding;

    public void setBinding(RubyBinding binding) {
        this.binding = binding;
    }

    @ExportMessage
    protected boolean hasMembers() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    protected Object getMembers(boolean includeInternal) {
        String[] variables = BindingNodes.LocalVariablesNode.listLocalVariablesWithDuplicates(this.binding.getFrame(), null).toArray(StringUtils.EMPTY_STRING_ARRAY);
        return new VariableNamesObject(variables);
    }

    @ExportMessage
    protected Object readMember(String member, @Cached @Cached.Exclusive BindingNodes.LocalVariableGetNode localVariableGetNode, @Bind(value="$node") Node node) throws UnknownIdentifierException {
        try {
            return localVariableGetNode.execute(node, this.binding, member);
        }
        catch (RaiseException e) {
            throw UnknownIdentifierException.create((String)member);
        }
    }

    @ExportMessage
    protected void writeMember(String member, Object value, @Cached BindingNodes.LocalVariableSetNode localVariableSetNode, @Bind(value="$node") Node node) throws UnknownIdentifierException {
        if (!BindingLocalVariablesObject.isValidLocalVariableName(member)) {
            throw UnknownIdentifierException.create((String)member);
        }
        localVariableSetNode.execute(node, this.binding, member, value);
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isMemberReadable"), @ExportMessage(name="isMemberModifiable")})
    protected boolean memberExists(String member, @Cached @Cached.Exclusive BindingNodes.HasLocalVariableNode hasLocalVariableNode) {
        return hasLocalVariableNode.execute(this.binding, member);
    }

    @ExportMessage
    protected boolean isMemberInsertable(String member, @CachedLibrary(value="this") InteropLibrary interopLibrary) {
        return BindingLocalVariablesObject.isValidLocalVariableName(member) && !interopLibrary.isMemberModifiable((Object)this, member);
    }

    private static boolean isValidLocalVariableName(String name) {
        return Identifiers.isValidLocalVariableName(name);
    }
}

