/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import java.util.concurrent.ThreadLocalRandom;
import org.truffleruby.debug.ChaosNodeGen;
import org.truffleruby.language.RubyBaseNodeWithExecute;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;

@NodeChild(value="valueNode", type=RubyBaseNodeWithExecute.class)
public abstract class ChaosNode
extends RubyContextSourceNode {
    public static ChaosNode create() {
        return ChaosNodeGen.create(null);
    }

    public static ChaosNode create(RubyBaseNodeWithExecute value) {
        return ChaosNodeGen.create(value);
    }

    abstract RubyBaseNodeWithExecute getValueNode();

    @Specialization
    Object chaos(int value) {
        if (this.randomBoolean()) {
            return value;
        }
        return (long)value;
    }

    @Specialization(guards={"fitsInInteger(value)"})
    Object chaos(long value) {
        if (this.randomBoolean()) {
            return value;
        }
        return (int)value;
    }

    @Specialization(guards={"!fitsInInteger(value)"})
    long passThrough(long value) {
        return value;
    }

    @Fallback
    Object chaos(Object value) {
        return value;
    }

    @CompilerDirectives.TruffleBoundary
    private boolean randomBoolean() {
        return ThreadLocalRandom.current().nextBoolean();
    }

    @Override
    public RubyNode cloneUninitialized() {
        ChaosNode copy = ChaosNodeGen.create(this.getValueNode().cloneUninitialized());
        return copy.copyFlags(this);
    }
}

