/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.debug;

import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.Profile;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.collections.Pair;
import org.truffleruby.core.proc.ProcCallTargets;
import org.truffleruby.core.support.DetailedInspectingSupport;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.methods.CachedLazyCallTargetSupplier;
import org.truffleruby.language.methods.ModuleBodyDefinition;

public abstract class TruffleASTPrinter {
    private static final Set<String> attributesToIgnore = Set.of("sourceCharIndex", "sourceLength", "bodyCopy");

    public static String dump(RubyRootNode rootNode, String focusedNodeClassName, int index) {
        Node node;
        try {
            Class<?> focusedNodeClass = Class.forName(focusedNodeClassName);
            List nodes = NodeUtil.findAllNodeInstances((Node)rootNode, focusedNodeClass);
            if (index >= nodes.size()) {
                String astString = NodeUtil.printTreeToString((Node)rootNode);
                return "Cannot find index=" + index + " node of class " + focusedNodeClassName + ". There are only " + nodes.size() + " of such nodes in the AST: \n" + astString;
            }
            node = (Node)nodes.get(index);
        }
        catch (ClassNotFoundException e) {
            String astString = NodeUtil.printTreeToString((Node)rootNode);
            String message = "Cannot find a Java class for a focused node class name " + focusedNodeClassName + ", that is supposed to be used in the AST: \n" + astString;
            return message;
        }
        if (node == null) {
            String astString = NodeUtil.printTreeToString((Node)rootNode);
            return "Cannot find " + focusedNodeClassName + " node in AST: \n" + astString;
        }
        try {
            StringBuilder out = new StringBuilder();
            TruffleASTPrinter.printTree(out, node, 0);
            return out.toString();
        }
        catch (IllegalAccessException e) {
            return "Exception: " + e;
        }
    }

    private static void printTree(StringBuilder out, Node node, int level) throws IllegalAccessException {
        List<Pair<String, Object>> attributes = TruffleASTPrinter.getNodeAttributes(node);
        List<Pair<String, Object>> children = TruffleASTPrinter.getNodeChildren(node);
        ArrayList<RootCallTarget> rootCallTargets = TruffleASTPrinter.getNestedCallTargets(attributes);
        attributes.sort(Comparator.comparing(Pair::getLeft));
        children.sort(Comparator.comparing(Pair::getLeft));
        TruffleASTPrinter.printNewLine(out, level);
        out.append(TruffleASTPrinter.nodeName(node));
        if (!attributes.isEmpty()) {
            TruffleASTPrinter.printAttributes(attributes, out, level);
        }
        if (!children.isEmpty()) {
            TruffleASTPrinter.printChildren(children, out, level);
        }
        if (!rootCallTargets.isEmpty()) {
            TruffleASTPrinter.printCallTargets(rootCallTargets, out, level);
        }
    }

    private static List<Pair<String, Object>> getNodeAttributes(Node node) {
        TreeSet generatedFieldNames = new TreeSet();
        if (node.getClass().getName().endsWith("Gen")) {
            List ownFieldNames = NodeUtil.collectFieldNames(node.getClass());
            List parentFieldNames = NodeUtil.collectFieldNames(node.getClass().getSuperclass());
            generatedFieldNames.addAll(ownFieldNames);
            generatedFieldNames.removeAll(parentFieldNames);
        }
        Map attributesMap = NodeUtil.collectNodeProperties((Node)node);
        List<Pair<String, Object>> attributes = new ArrayList(attributesMap.entrySet()).stream().map(entry -> Pair.create((Object)((String)entry.getKey()), entry.getValue())).map(pair -> {
            if (((String)pair.getLeft()).startsWith("field.")) {
                String name = ((String)pair.getLeft()).substring("field.".length());
                return Pair.create((Object)name, (Object)pair.getRight());
            }
            return pair;
        }).filter(pair -> pair.getRight() != null).filter(pair -> !attributesToIgnore.contains(pair.getLeft())).filter(pair -> !generatedFieldNames.contains(pair.getLeft())).filter(pair -> !(pair.getRight() instanceof Profile)).collect(Collectors.toList());
        return attributes;
    }

    private static List<Pair<String, Object>> getNodeChildren(Node node) {
        Map childrenMapWithFlattenArrays = NodeUtil.collectNodeChildren((Node)node);
        HashMap<String, ArrayList<Object>> childrenMap = new HashMap<String, ArrayList<Object>>();
        for (Map.Entry entry2 : childrenMapWithFlattenArrays.entrySet()) {
            if (((String)entry2.getKey()).contains("[")) {
                ArrayList values;
                String key = (String)entry2.getKey();
                String name = key.substring(0, key.indexOf("["));
                if (childrenMap.get(name) == null) {
                    values = new ArrayList();
                    values.add(entry2.getValue());
                    childrenMap.put(name, values);
                    continue;
                }
                values = (ArrayList)childrenMap.get(name);
                values.add(entry2.getValue());
                continue;
            }
            childrenMap.put((String)entry2.getKey(), (ArrayList<Object>)entry2.getValue());
        }
        List<Pair<String, Object>> children = new ArrayList(childrenMap.entrySet()).stream().map(entry -> Pair.create((Object)((String)entry.getKey()), entry.getValue())).filter(pair -> pair.getRight() != null).collect(Collectors.toList());
        return children;
    }

    private static ArrayList<RootCallTarget> getNestedCallTargets(List<Pair<String, Object>> attributes) {
        ArrayList<RootCallTarget> rootCallTargets = new ArrayList<RootCallTarget>();
        for (Pair<String, Object> pair : attributes) {
            Object value = pair.getRight();
            if (value instanceof ProcCallTargets) {
                ProcCallTargets procsCallTargets = (ProcCallTargets)value;
                if (procsCallTargets.hasCallTargetForProc()) {
                    rootCallTargets.add(procsCallTargets.getCallTargetForProc());
                }
                if (procsCallTargets.hasCallTargetForLambda()) {
                    rootCallTargets.add(procsCallTargets.getCallTargetForLambda());
                }
            }
            if (value instanceof ModuleBodyDefinition) {
                ModuleBodyDefinition moduleBodyDefinition = (ModuleBodyDefinition)value;
                rootCallTargets.add(moduleBodyDefinition.getCallTarget());
            }
            if (!(value instanceof CachedLazyCallTargetSupplier)) continue;
            CachedLazyCallTargetSupplier cachedLazyCallTargetSupplier = (CachedLazyCallTargetSupplier)value;
            RootCallTarget rootCallTarget = cachedLazyCallTargetSupplier.get();
            rootCallTargets.add(rootCallTarget);
        }
        return rootCallTargets;
    }

    private static void printAttributes(List<Pair<String, Object>> attributes, StringBuilder out, int level) {
        TruffleASTPrinter.printNewLine(out, level + 1);
        out.append("attributes:");
        for (Pair<String, Object> pair : attributes) {
            TruffleASTPrinter.printNewLine(out, level + 2);
            String name = (String)pair.getLeft();
            Object value = pair.getRight();
            Object string = TruffleASTPrinter.valueOrArrayToString(value);
            string = ((String)string).replaceAll("(?<!^|@)@[0-9a-f]+", "@...");
            string = ((String)string).replaceAll("\\$\\$Lambda[^@]+@", Matcher.quoteReplacement("$$Lambda$.../0x...@"));
            string = ((String)string).replaceAll("\\[(\\d+):\\d+ - (\\d+):\\d+\\]", "[$1 - $2]");
            if (value instanceof String || ((String)string).isEmpty()) {
                string = "\"" + (String)string + "\"";
            }
            out.append(name + " = " + (String)string);
        }
    }

    private static void printChildren(List<Pair<String, Object>> children, StringBuilder out, int level) throws IllegalAccessException {
        TruffleASTPrinter.printNewLine(out, level + 1);
        out.append("children:");
        for (Pair<String, Object> pair : children) {
            Object value = pair.getRight();
            TruffleASTPrinter.printNewLine(out, level + 2);
            out.append((String)pair.getLeft());
            if (value instanceof Node) {
                out.append(" =");
                TruffleASTPrinter.printTree(out, (Node)value, level + 3);
                continue;
            }
            if (!(value instanceof ArrayList)) continue;
            ArrayList values = (ArrayList)value;
            out.append(" = [");
            for (Object child : values) {
                TruffleASTPrinter.printTree(out, (Node)child, level + 3);
            }
            TruffleASTPrinter.printNewLine(out, level + 2);
            out.append("]");
        }
    }

    private static void printCallTargets(ArrayList<RootCallTarget> rootCallTargets, StringBuilder out, int level) throws IllegalAccessException {
        TruffleASTPrinter.printNewLine(out, level + 1);
        out.append("call targets:");
        for (RootCallTarget callTarget : rootCallTargets) {
            RootNode rootNode = callTarget.getRootNode();
            TruffleASTPrinter.printTree(out, (Node)rootNode, level + 2);
        }
    }

    private static void printNewLine(StringBuilder out, int level) {
        out.append("\n");
        for (int i = 0; i < level; ++i) {
            out.append("    ");
        }
    }

    private static String nodeName(Node node) {
        return TruffleASTPrinter.className(node.getClass());
    }

    private static String className(Class<?> clazz) {
        String name = clazz.getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    private static String valueOrArrayToString(Object value) {
        String valueString;
        if (value.getClass().isArray()) {
            Object[] elements = (Object[])value;
            String[] strings = new String[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                Object element = elements[i];
                strings[i] = TruffleASTPrinter.valueToString(element);
            }
            valueString = Stream.of(strings).collect(Collectors.joining(", ", "[", "]"));
        } else {
            valueString = TruffleASTPrinter.valueToString(value);
        }
        return valueString;
    }

    private static String valueToString(Object value) {
        String string = value instanceof DetailedInspectingSupport ? ((DetailedInspectingSupport)value).toStringWithDetails() : value.toString();
        return string;
    }
}

