/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.extra;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.ReentrantLock;
import org.truffleruby.Layouts;
import org.truffleruby.RubyContext;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.CoreMethodNode;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.mutex.MutexOperations;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.language.RubyDynamicObject;
import org.truffleruby.language.yield.CallBlockNode;

@CoreModule(value="TruffleRuby")
public abstract class TruffleRubyNodes {

    @CoreMethod(names={"synchronized"}, onSingleton=true, required=1, needsBlock=true)
    public static abstract class SynchronizedNode
    extends CoreMethodArrayArgumentsNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="getDynamicObjectCacheLimit()")
        static Object synchronize(RubyDynamicObject object, RubyProc block, @CachedLibrary(value="object") DynamicObjectLibrary objectLibrary, @Cached CallBlockNode yieldNode, @Cached InlinedBranchProfile initializeLockProfile, @Bind(value="this") Node node) {
            ReentrantLock lock = SynchronizedNode.getLock(node, object, objectLibrary, initializeLockProfile);
            MutexOperations.lockInternal(SynchronizedNode.getContext(node), lock, node);
            try {
                Object object2 = yieldNode.yield(block, new Object[0]);
                return object2;
            }
            finally {
                MutexOperations.unlockInternal(lock);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static ReentrantLock getLock(Node node, RubyDynamicObject object, DynamicObjectLibrary objectLibrary, InlinedBranchProfile initializeLockProfile) {
            ReentrantLock lock = (ReentrantLock)objectLibrary.getOrDefault((DynamicObject)object, (Object)Layouts.OBJECT_LOCK, null);
            if (lock != null) {
                return lock;
            }
            initializeLockProfile.enter(node);
            RubyDynamicObject rubyDynamicObject = object;
            synchronized (rubyDynamicObject) {
                lock = (ReentrantLock)objectLibrary.getOrDefault((DynamicObject)object, (Object)Layouts.OBJECT_LOCK, null);
                if (lock != null) {
                    return lock;
                }
                lock = new ReentrantLock();
                objectLibrary.put((DynamicObject)object, (Object)Layouts.OBJECT_LOCK, (Object)lock);
                return lock;
            }
        }
    }

    @CoreMethod(names={"full_memory_barrier"}, onSingleton=true)
    public static abstract class FullMemoryBarrierPrimitiveNode
    extends CoreMethodNode {
        @Specialization
        Object fullMemoryBarrier() {
            VarHandle.fullFence();
            return nil;
        }
    }

    @CoreMethod(names={"cexts?"}, onSingleton=true)
    public static abstract class SulongNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isSulong() {
            return SulongNode.isSulongAvailable(this.getContext());
        }

        @CompilerDirectives.TruffleBoundary
        public static boolean isSulongAvailable(RubyContext context) {
            return context.getEnv().isMimeTypeSupported("application/x-llvm-ir-bitcode");
        }
    }

    @CoreMethod(names={"native?"}, onSingleton=true)
    public static abstract class NativeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isNative() {
            return TruffleOptions.AOT;
        }
    }

    @CoreMethod(names={"jit?"}, onSingleton=true)
    public static abstract class GraalNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        static boolean isGraal() {
            return Truffle.getRuntime().getName().contains("Graal");
        }
    }

    @CoreMethod(names={"graalvm_home"}, onSingleton=true)
    public static abstract class GraalvmHomeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object graalvmHome(@Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            String value = GraalvmHomeNode.getProperty("org.graalvm.home");
            if (value == null) {
                return nil;
            }
            return this.createString(fromJavaStringNode, value, Encodings.UTF_8);
        }

        @CompilerDirectives.TruffleBoundary
        private static String getProperty(String key) {
            return System.getProperty(key);
        }
    }
}

