/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.interop.ForeignToRubyArgumentsNode;
import org.truffleruby.language.dispatch.DispatchNode;

@ExportLibrary(value=ReflectionLibrary.class)
public final class ProxyForeignObject
implements TruffleObject {
    final Object delegate;
    private final Object logger;
    private static final Message EXECUTABLE = Message.resolve(InteropLibrary.class, (String)"execute");
    private static final Message INVOKE = Message.resolve(InteropLibrary.class, (String)"invokeMember");
    private static final Message INSTANTIATE = Message.resolve(InteropLibrary.class, (String)"instantiate");
    private static final Message IS_META_INSTANCE = Message.resolve(InteropLibrary.class, (String)"isMetaInstance");

    public ProxyForeignObject(Object delegate) {
        this(delegate, null);
    }

    public ProxyForeignObject(Object delegate, Object logger) {
        this.delegate = delegate;
        this.logger = logger;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    protected Object send(Message message, Object[] rawArgs, @Cached DispatchNode dispatchNode, @Cached ForeignToRubyArgumentsNode foreignToRubyArgumentsNode, @CachedLibrary(value="this.delegate") ReflectionLibrary reflections, @CachedLibrary(value="this") ReflectionLibrary node) throws Exception {
        if (message == IS_META_INSTANCE) {
            rawArgs = (Object[])rawArgs.clone();
            for (int i = 0; i < rawArgs.length; ++i) {
                rawArgs[i] = ProxyForeignObject.unwrap(rawArgs[i]);
            }
        }
        if (this.logger != null) {
            Object[] args = message == EXECUTABLE || message == INSTANTIATE ? (Object[])rawArgs[0] : (message == INVOKE ? ArrayUtils.unshift((Object[])rawArgs[1], rawArgs[0]) : rawArgs);
            Object[] loggingArgs = ArrayUtils.unshift(args, message.getSimpleName());
            for (int i = 0; i < loggingArgs.length; ++i) {
                if (!(loggingArgs[i] instanceof InteropLibrary)) continue;
                loggingArgs[i] = RubyLanguage.get((Node)node).getSymbol("InteropLibrary");
            }
            Object[] convertedArgs = foreignToRubyArgumentsNode.executeConvert(loggingArgs);
            dispatchNode.call(this.logger, "<<", convertedArgs);
        }
        return reflections.send(this.delegate, message, rawArgs);
    }

    private static Object unwrap(Object value) {
        if (value instanceof ProxyForeignObject) {
            return ((ProxyForeignObject)value).delegate;
        }
        return value;
    }
}

