/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.util.function.Function;
import java.util.function.Predicate;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.collections.Memo;
import org.truffleruby.core.CoreLibrary;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.backtrace.Backtrace;
import org.truffleruby.language.backtrace.BacktraceFormatter;
import org.truffleruby.language.backtrace.InternalRootNode;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.methods.SharedMethodInfo;

public final class CallStackManager {
    private final RubyLanguage language;
    private final RubyContext context;

    public CallStackManager(RubyLanguage language, RubyContext context) {
        this.language = language;
        this.context = context;
    }

    @CompilerDirectives.TruffleBoundary
    public Frame getCurrentFrame(FrameInstance.FrameAccess frameAccess) {
        return this.iterateFrames(0, f -> true, f -> f.getFrame(frameAccess));
    }

    @CompilerDirectives.TruffleBoundary
    public Frame getCurrentRubyFrame(FrameInstance.FrameAccess frameAccess) {
        return this.iterateFrames(0, f -> CallStackManager.isRubyFrame(f.getFrame(FrameInstance.FrameAccess.READ_ONLY)), f -> f.getFrame(frameAccess));
    }

    @CompilerDirectives.TruffleBoundary
    public Frame getCallerFrame(FrameInstance.FrameAccess frameAccess) {
        return this.getCallerFrame(f -> CallStackManager.isRubyFrame(f.getFrame(FrameInstance.FrameAccess.READ_ONLY)), frameAccess);
    }

    @CompilerDirectives.TruffleBoundary
    public Frame getNonJavaCoreCallerFrame(FrameInstance.FrameAccess frameAccess) {
        return this.getCallerFrame(f -> {
            Frame frame = f.getFrame(FrameInstance.FrameAccess.READ_ONLY);
            return CallStackManager.isRubyFrame(frame) && !CallStackManager.isJavaCore(CallStackManager.tryGetMethod(frame));
        }, frameAccess);
    }

    @CompilerDirectives.TruffleBoundary
    public <R> R iterateFrameNotInModules(Object[] modules, Function<FrameInstance, R> action) {
        Memo<Boolean> skippedFirstFrameFound = new Memo<Boolean>(false);
        return this.iterateFrames(1, frameInstance -> {
            InternalMethod method = CallStackManager.tryGetMethod(frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY));
            if (method != null && !ArrayUtils.contains(modules, method.getDeclaringModule())) {
                if (((Boolean)skippedFirstFrameFound.get()).booleanValue()) {
                    return true;
                }
                skippedFirstFrameFound.set(true);
            }
            return false;
        }, action);
    }

    @CompilerDirectives.TruffleBoundary
    public Node getCallerNode() {
        return this.getCallerNode(1, true);
    }

    @CompilerDirectives.TruffleBoundary
    public Node getCallerNode(int skip, boolean onlyRubyFrames) {
        return this.iterateFrames(skip, frameInstance -> {
            if (onlyRubyFrames) {
                return CallStackManager.isRubyFrame(frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY));
            }
            return true;
        }, f -> f.getCallNode());
    }

    @CompilerDirectives.TruffleBoundary
    public InternalMethod getCallingMethod() {
        return CallStackManager.tryGetMethod(this.getCallerFrame(FrameInstance.FrameAccess.READ_ONLY));
    }

    @CompilerDirectives.TruffleBoundary
    public SourceSection getTopMostUserSourceSection(SourceSection encapsulatingSourceSection) {
        if (BacktraceFormatter.isUserSourceSection(this.language, encapsulatingSourceSection)) {
            return encapsulatingSourceSection;
        }
        return this.getTopMostUserSourceSection();
    }

    @CompilerDirectives.TruffleBoundary
    public SourceSection getTopMostUserSourceSection() {
        return (SourceSection)Truffle.getRuntime().iterateFrames(frameInstance -> {
            Node callNode = frameInstance.getCallNode();
            if (callNode == null) {
                return null;
            }
            SourceSection sourceSection = callNode.getEncapsulatingSourceSection();
            if (BacktraceFormatter.isUserSourceSection(this.context.getLanguageSlow(), sourceSection)) {
                return sourceSection;
            }
            return null;
        });
    }

    private Frame getCallerFrame(Predicate<FrameInstance> filter, FrameInstance.FrameAccess frameAccess) {
        return this.iterateFrames(1, filter, f -> f.getFrame(frameAccess));
    }

    @CompilerDirectives.TruffleBoundary
    public void iterateFrameBindings(int skip, Function<FrameInstance, Object> action) {
        this.iterateFrames(skip, frameInstance -> {
            if (this.ignoreFrame(frameInstance.getCallNode(), (RootCallTarget)frameInstance.getCallTarget())) {
                return false;
            }
            RootNode rootNode = ((RootCallTarget)frameInstance.getCallTarget()).getRootNode();
            return rootNode instanceof RubyRootNode || frameInstance.getCallNode() != null;
        }, action);
    }

    private <R> R iterateFrames(int skip, Predicate<FrameInstance> filter, Function<FrameInstance, R> action) {
        return (R)Truffle.getRuntime().iterateFrames(new FilterApplyVisitor<R>(skip, filter, action));
    }

    public static boolean isRubyFrame(Frame frame) {
        return CallStackManager.tryGetMethod(frame) != null;
    }

    private static InternalMethod tryGetMethod(Frame frame) {
        return RubyArguments.tryGetMethod(frame);
    }

    public static boolean isJavaCore(InternalMethod method) {
        return method != null && method.getSharedMethodInfo().getSourceSection() == CoreLibrary.JAVA_CORE_SOURCE_SECTION;
    }

    public Backtrace getBacktrace(Node currentNode) {
        return this.getBacktrace(currentNode, 0, null);
    }

    public Backtrace getBacktrace(Node currentNode, int omit) {
        return this.getBacktrace(currentNode, omit, null);
    }

    public Backtrace getBacktrace(Node currentNode, int omit, Throwable javaThrowable) {
        if ((this.context.getOptions().EXCEPTIONS_STORE_JAVA || this.context.getOptions().BACKTRACES_INTERLEAVE_JAVA) && javaThrowable == null) {
            javaThrowable = this.newException();
        }
        Node adoptableNode = RubyNode.getAdoptedNode(currentNode);
        return new Backtrace(adoptableNode, omit, javaThrowable);
    }

    @SuppressFBWarnings(value={"ES"})
    public boolean ignoreFrame(Node callNode, RootCallTarget callTarget) {
        if (callNode == null) {
            return false;
        }
        RootNode rootNode = callNode.getRootNode();
        if (rootNode instanceof RubyRootNode) {
            SharedMethodInfo sharedMethodInfo = ((RubyRootNode)rootNode).getSharedMethodInfo();
            if (this.context.getCoreLibrary().isTruffleBootMainMethod(sharedMethodInfo)) {
                return true;
            }
            SourceSection sourceSection = sharedMethodInfo.getSourceSection();
            if (sourceSection != null && sourceSection.getSource().getName() == "main_boot_source") {
                return true;
            }
        }
        return rootNode instanceof InternalRootNode || callNode.getEncapsulatingSourceSection() == null;
    }

    @CompilerDirectives.TruffleBoundary
    private Exception newException() {
        return new Exception();
    }

    private static final class FilterApplyVisitor<R>
    implements FrameInstanceVisitor<R> {
        private final int skip;
        private final Predicate<FrameInstance> filter;
        private final Function<FrameInstance, R> action;
        private int skipped = 0;

        private FilterApplyVisitor(int skip, Predicate<FrameInstance> filter, Function<FrameInstance, R> action) {
            this.skip = skip;
            this.filter = filter;
            this.action = action;
        }

        public R visitFrame(FrameInstance frameInstance) {
            if (this.skipped < this.skip) {
                ++this.skipped;
                return null;
            }
            if (this.filter.test(frameInstance)) {
                return this.action.apply(frameInstance);
            }
            return null;
        }
    }
}

