/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.Split;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.language.RubyCheckArityRootNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.control.DynamicReturnException;
import org.truffleruby.language.control.LocalReturnException;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.control.RetryException;
import org.truffleruby.language.control.ReturnID;
import org.truffleruby.language.methods.Arity;
import org.truffleruby.language.methods.SharedMethodInfo;
import org.truffleruby.language.methods.TranslateExceptionNode;
import org.truffleruby.language.threadlocal.SpecialVariableStorage;

public class RubyMethodRootNode
extends RubyCheckArityRootNode {
    @Node.Child
    private TranslateExceptionNode translateExceptionNode;
    @CompilerDirectives.CompilationFinal
    private boolean localReturnProfile;
    @CompilerDirectives.CompilationFinal
    private boolean retryProfile;
    @CompilerDirectives.CompilationFinal
    private boolean matchingReturnProfile;
    @CompilerDirectives.CompilationFinal
    private boolean nonMatchingReturnProfile;

    public RubyMethodRootNode(RubyLanguage language, SourceSection sourceSection, FrameDescriptor frameDescriptor, SharedMethodInfo sharedMethodInfo, RubyNode body, Split split, ReturnID returnID, Arity arityForCheck) {
        super(language, sourceSection, frameDescriptor, sharedMethodInfo, body, split, returnID, arityForCheck);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        TruffleSafepoint.poll((Node)this);
        this.checkArity(frame);
        assert (SpecialVariableStorage.hasSpecialVariableStorageSlot((Frame)frame));
        Assumption specialVariablesAssumption = SpecialVariableStorage.getAssumption(frame.getFrameDescriptor());
        CompilerAsserts.partialEvaluationConstant((Object)specialVariablesAssumption);
        if (!specialVariablesAssumption.isValid()) {
            SpecialVariableStorage.set((Frame)frame, new SpecialVariableStorage());
        }
        try {
            return this.body.execute(frame);
        }
        catch (LocalReturnException e) {
            if (!this.localReturnProfile) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.localReturnProfile = true;
            }
            return e.getValue();
        }
        catch (DynamicReturnException e) {
            if (this.returnID != ReturnID.INVALID && e.getReturnID() == this.returnID) {
                if (!this.matchingReturnProfile) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.matchingReturnProfile = true;
                }
                return e.getValue();
            }
            if (!this.nonMatchingReturnProfile) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.nonMatchingReturnProfile = true;
            }
            throw e;
        }
        catch (RetryException e) {
            if (!this.retryProfile) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.retryProfile = true;
            }
            throw new RaiseException(this.getContext(), (RubyException)this.getContext().getCoreExceptions().syntaxErrorInvalidRetry((Node)this));
        }
        catch (Throwable t) {
            if (this.translateExceptionNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.translateExceptionNode = (TranslateExceptionNode)this.insert(TranslateExceptionNode.create());
            }
            throw this.translateExceptionNode.executeTranslation(t);
        }
    }

    @Override
    protected RubyRootNode cloneUninitializedRootNode() {
        return new RubyMethodRootNode(this.getLanguage(), this.getSourceSection(), this.getFrameDescriptor(), this.getSharedMethodInfo(), this.body.cloneUninitialized(), this.getSplit(), this.returnID, this.arityForCheck);
    }
}

