/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import java.util.Objects;
import org.truffleruby.language.NoImplicitCastsToLong;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.ProfileArgumentNodeGen;

@NodeInfo(cost=NodeCost.NONE)
@TypeSystemReference(value=NoImplicitCastsToLong.class)
@ImportStatic(value={CompilerDirectives.class})
@NodeChild(value="childNode", type=RubyNode.class)
public abstract class ProfileArgumentNode
extends RubyContextSourceNode {
    protected abstract RubyNode getChildNode();

    @Specialization(guards={"value == cachedValue"}, limit="1")
    boolean cacheBoolean(boolean value, @Cached(value="value") boolean cachedValue) {
        return cachedValue;
    }

    @Specialization(guards={"value == cachedValue"}, limit="1")
    int cacheInt(int value, @Cached(value="value") int cachedValue) {
        return cachedValue;
    }

    @Specialization(guards={"value == cachedValue"}, limit="1")
    long cacheLong(long value, @Cached(value="value") long cachedValue) {
        return cachedValue;
    }

    @Specialization(guards={"exactCompare(value, cachedValue)"}, limit="1")
    double cacheDouble(double value, @Cached(value="value") double cachedValue) {
        return cachedValue;
    }

    @Specialization(guards={"isExact(object, cachedClass)", "!isPrimitiveClass(cachedClass)"}, limit="1")
    Object cacheClass(Object object, @Cached(value="getClassOrObject(object)") Class<?> cachedClass) {
        if (CompilerDirectives.inInterpreter()) {
            return object;
        }
        return CompilerDirectives.castExact((Object)object, cachedClass);
    }

    @Specialization(replaces={"cacheBoolean", "cacheInt", "cacheLong", "cacheDouble", "cacheClass"})
    Object unprofiled(Object object) {
        assert (RubyGuards.assertIsValidRubyValue(object));
        return object;
    }

    protected static boolean exactCompare(double a, double b) {
        return Double.doubleToRawLongBits(a) == Double.doubleToRawLongBits(b);
    }

    @NeverDefault
    protected static Class<?> getClassOrObject(Object value) {
        return value == null ? Objects.class : value.getClass();
    }

    @Override
    public String toString() {
        return "Profiled(" + this.getChildNode() + ")";
    }

    @Override
    public RubyNode cloneUninitialized() {
        ProfileArgumentNode copy = ProfileArgumentNodeGen.create(this.getChildNode().cloneUninitialized());
        return copy.copyFlags(this);
    }
}

