/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.arguments;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.RubyArguments;

public final class ReadPostArgumentNode
extends RubyContextSourceNode {
    private final int indexFromCount;
    private final boolean keywordArguments;
    private final int required;
    private final ConditionProfile enoughArguments = ConditionProfile.create();

    public ReadPostArgumentNode(int indexFromCount, boolean keywordArguments, int required) {
        this.indexFromCount = indexFromCount;
        this.keywordArguments = keywordArguments;
        this.required = required;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        int positionalArgumentsCount = RubyArguments.getPositionalArgumentsCount((Frame)frame, this.keywordArguments);
        if (this.enoughArguments.profile(positionalArgumentsCount >= this.required)) {
            int effectiveIndex = positionalArgumentsCount - this.indexFromCount;
            return RubyArguments.getArgument((Frame)frame, effectiveIndex);
        }
        return nil;
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " -" + this.indexFromCount;
    }

    @Override
    public RubyNode cloneUninitialized() {
        ReadPostArgumentNode copy = new ReadPostArgumentNode(this.indexFromCount, this.keywordArguments, this.required);
        return copy.copyFlags(this);
    }
}

