/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.arguments;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.IntValueProfile;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.arguments.RubyArguments;

public final class SplatToArgsNode
extends RubyBaseNode {
    @Node.Child
    ArrayStoreLibrary stores;
    final IntValueProfile splatSizeProfile = IntValueProfile.create();

    public SplatToArgsNode(RubyLanguage language) {
        this.stores = ArrayStoreLibrary.createDispatched(language);
    }

    public Object[] execute(Object receiver, RubyArray splatted) {
        int size = this.splatSizeProfile.profile(splatted.size);
        Object store = splatted.getStore();
        Object[] newArgs = RubyArguments.allocate(size);
        RubyArguments.setSelf(newArgs, receiver);
        this.stores.copyContents(store, 0, newArgs, RubyArguments.RUNTIME_ARGUMENT_COUNT, size);
        return newArgs;
    }
}

