/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.backtrace;

import java.util.ArrayList;
import java.util.List;

public final class BacktraceInterleaver {
    public static List<String> interleave(List<String> rubyBacktrace, StackTraceElement[] javaStacktrace, int omitted) {
        ArrayList<String> interleaved = new ArrayList<String>();
        int javaIndex = 0;
        int rubyIndex = 0;
        int toOmit = omitted;
        while (javaIndex < javaStacktrace.length || rubyIndex < rubyBacktrace.size()) {
            if (javaIndex >= javaStacktrace.length || BacktraceInterleaver.isCallBoundary(javaStacktrace[javaIndex]) && rubyIndex < rubyBacktrace.size()) {
                if (toOmit == 0) {
                    interleaved.add(rubyBacktrace.get(rubyIndex));
                    ++rubyIndex;
                } else {
                    --toOmit;
                }
            }
            if (javaIndex >= javaStacktrace.length) continue;
            interleaved.add(String.format("\t\t%s", javaStacktrace[javaIndex]));
            if (BacktraceInterleaver.isIntoRuby(javaStacktrace, javaIndex)) {
                interleaved.add("\t\t\tforeign call goes into Ruby");
            }
            if (BacktraceInterleaver.isForeignCall(javaStacktrace[javaIndex])) {
                interleaved.add("\t\t\tforeign call being made");
            }
            ++javaIndex;
        }
        return interleaved;
    }

    public static boolean isCallBoundary(StackTraceElement element) {
        String className = element.getClassName();
        String methodName = element.getMethodName();
        return (className.equals("com.oracle.truffle.runtime.OptimizedCallTarget") || className.equals("org.graalvm.compiler.truffle.runtime.OptimizedCallTarget")) && methodName.equals("executeRootNode") || className.equals("com.oracle.truffle.api.impl.DefaultCallTarget") && methodName.equals("callDirectOrIndirect");
    }

    private static boolean isIntoRuby(StackTraceElement[] elements, int index) {
        if (index + 1 >= elements.length) {
            return false;
        }
        return elements[index].toString().startsWith("org.truffleruby.interop.RubyMessageResolutionForeign") && !elements[index + 1].toString().startsWith("org.truffleruby.interop.RubyMessageResolutionForeign");
    }

    private static boolean isForeignCall(StackTraceElement element) {
        return element.toString().startsWith("com.oracle.truffle.api.interop.ForeignAccess.send");
    }
}

