/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.constants;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.ArrayList;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.module.ConstantLookupResult;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.LazyWarnNode;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.RubyConstant;
import org.truffleruby.language.constants.LookupConstantBaseNode;
import org.truffleruby.language.constants.LookupConstantInterface;
import org.truffleruby.language.constants.LookupConstantNodeGen;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.parser.Identifiers;

public abstract class LookupConstantNode
extends LookupConstantBaseNode
implements LookupConstantInterface {
    private final boolean ignoreVisibility;
    private final boolean lookInObject;

    @NeverDefault
    public static LookupConstantNode create(boolean ignoreVisibility, boolean lookInObject) {
        return LookupConstantNodeGen.create(ignoreVisibility, lookInObject);
    }

    public LookupConstantNode(boolean ignoreVisibility, boolean lookInObject) {
        this.ignoreVisibility = ignoreVisibility;
        this.lookInObject = lookInObject;
    }

    public abstract RubyConstant executeLookupConstant(Object var1, String var2, boolean var3);

    @Override
    public RubyConstant lookupConstant(Node node, LexicalScope lexicalScope, RubyModule module, String name, boolean checkName) {
        return this.executeLookupConstant(module, name, checkName);
    }

    @Specialization(guards={"isSingleContext()", "module == cachedModule", "checkName == cachedCheckName", "guardName(node, name, cachedName, sameNameProfile)"}, assumptions={"constant.getAssumptions()"}, limit="getCacheLimit()")
    static RubyConstant lookupConstant(RubyModule module, String name, boolean checkName, @Cached(value="module") RubyModule cachedModule, @Cached(value="name") String cachedName, @Cached(value="checkName") boolean cachedCheckName, @Cached(value="isValidName(cachedCheckName, cachedName)") boolean isValidConstantName, @Cached(value="doLookup(cachedModule, cachedName)") ConstantLookupResult constant, @Cached(value="isVisible(cachedModule, constant)") boolean isVisible, @Cached @Cached.Exclusive InlinedConditionProfile sameNameProfile, @Cached LazyWarnNode lazyWarnNode, @Bind(value="this") Node node) {
        if (!isValidConstantName) {
            throw new RaiseException(LookupConstantNode.getContext(node), (RubyException)LookupConstantNode.coreExceptions(node).nameErrorWrongConstantName(cachedName, node));
        }
        if (!isVisible) {
            throw new RaiseException(LookupConstantNode.getContext(node), (RubyException)LookupConstantNode.coreExceptions(node).nameErrorPrivateConstant(module, name, node));
        }
        if (constant.isDeprecated()) {
            LookupConstantNode.warnDeprecatedConstant(node, lazyWarnNode.get(node), module, name);
        }
        return constant.getConstant();
    }

    @Specialization
    RubyConstant lookupConstantUncached(RubyModule module, String name, boolean checkName, @Cached @Cached.Exclusive InlinedConditionProfile isValidConstantNameProfile, @Cached @Cached.Exclusive InlinedConditionProfile isVisibleProfile, @Cached @Cached.Exclusive InlinedConditionProfile isDeprecatedProfile) {
        ConstantLookupResult constant = this.doLookup(module, name);
        boolean isVisible = this.isVisible(module, constant);
        if (!isValidConstantNameProfile.profile((Node)this, this.isValidName(checkName, name))) {
            throw new RaiseException(this.getContext(), (RubyException)this.coreExceptions().nameErrorWrongConstantName(name, this));
        }
        if (isVisibleProfile.profile((Node)this, !isVisible)) {
            throw new RaiseException(this.getContext(), (RubyException)this.coreExceptions().nameErrorPrivateConstant(module, name, this));
        }
        if (isDeprecatedProfile.profile((Node)this, constant.isDeprecated())) {
            this.warnDeprecatedConstant(module, name);
        }
        return constant.getConstant();
    }

    @SuppressFBWarnings(value={"ES"})
    protected boolean guardName(Node node, String name, String cachedName, InlinedConditionProfile sameNameProfile) {
        if (sameNameProfile.profile(node, name == cachedName)) {
            return true;
        }
        return name.equals(cachedName);
    }

    @CompilerDirectives.TruffleBoundary
    protected ConstantLookupResult doLookup(RubyModule module, String name) {
        if (this.lookInObject) {
            return ModuleOperations.lookupConstantAndObject(this.getContext(), module, name, new ArrayList<Assumption>());
        }
        return ModuleOperations.lookupConstant(this.getContext(), module, name);
    }

    protected boolean isVisible(RubyModule module, ConstantLookupResult constant) {
        return this.ignoreVisibility || constant.isVisibleTo(this.getContext(), LexicalScope.NONE, module);
    }

    protected boolean isValidConstantName(String name) {
        return Identifiers.isValidConstantName(name);
    }

    protected boolean isValidName(boolean checkName, String name) {
        if (checkName) {
            return this.isValidConstantName(name);
        }
        return true;
    }
}

