/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.constants;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.core.module.ConstantLookupResult;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.RubyConstant;
import org.truffleruby.language.constants.LookupConstantBaseNode;
import org.truffleruby.language.constants.LookupConstantInterface;

public abstract class LookupConstantWithDynamicScopeNode
extends LookupConstantBaseNode
implements LookupConstantInterface {
    private final String name;

    public LookupConstantWithDynamicScopeNode(String name) {
        this.name = name;
    }

    public abstract RubyConstant executeLookupConstant(LexicalScope var1);

    @Override
    @SuppressFBWarnings(value={"ES"})
    public RubyConstant lookupConstant(Node node, LexicalScope lexicalScope, RubyModule module, String name, boolean checkName) {
        assert (name == this.name);
        return this.executeLookupConstant(lexicalScope);
    }

    @Specialization(guards={"isSingleContext()", "lexicalScope == cachedLexicalScope"}, assumptions={"constant.getAssumptions()"}, limit="getCacheLimit()")
    RubyConstant lookupConstant(LexicalScope lexicalScope, @Cached(value="lexicalScope") LexicalScope cachedLexicalScope, @Cached(value="doLookup(cachedLexicalScope)") ConstantLookupResult constant) {
        if (constant.isDeprecated()) {
            this.warnDeprecatedConstant(constant.getConstant().getDeclaringModule(), this.name);
        }
        return constant.getConstant();
    }

    @Specialization
    RubyConstant lookupConstantUncached(LexicalScope lexicalScope, @Cached InlinedConditionProfile isDeprecatedProfile) {
        ConstantLookupResult constant = this.doLookup(lexicalScope);
        if (isDeprecatedProfile.profile((Node)this, constant.isDeprecated())) {
            this.warnDeprecatedConstant(constant.getConstant().getDeclaringModule(), this.name);
        }
        return constant.getConstant();
    }

    @CompilerDirectives.TruffleBoundary
    protected ConstantLookupResult doLookup(LexicalScope lexicalScope) {
        return ModuleOperations.lookupConstantWithLexicalScope(this.getContext(), lexicalScope, this.name);
    }
}

