/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.constants;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.string.FrozenStrings;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.RubyConstant;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.constants.GetConstantNode;
import org.truffleruby.language.constants.LookupConstantNode;
import org.truffleruby.language.constants.WriteConstantNode;
import org.truffleruby.language.control.RaiseException;

public final class ReadConstantNode
extends RubyContextSourceNode {
    private final String name;
    private final BranchProfile notModuleProfile = BranchProfile.create();
    @Node.Child
    private RubyNode moduleNode;
    @Node.Child
    private LookupConstantNode lookupConstantNode;
    @Node.Child
    private GetConstantNode getConstantNode;

    public ReadConstantNode(RubyNode moduleNode, String name) {
        this.name = name;
        this.moduleNode = moduleNode;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.lookupAndGetConstant(this.evaluateModule(frame));
    }

    private Object lookupAndGetConstant(RubyModule module) {
        return this.getGetConstantNode().lookupAndResolveConstant(LexicalScope.IGNORE, module, this.name, this.getLookupConstantNode(), true);
    }

    public Object getConstant(RubyModule module, RubyConstant constant) {
        return this.getGetConstantNode().executeGetConstant(LexicalScope.IGNORE, module, this.name, constant, this.getLookupConstantNode(), true);
    }

    private GetConstantNode getGetConstantNode() {
        if (this.getConstantNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getConstantNode = (GetConstantNode)this.insert(GetConstantNode.create());
        }
        return this.getConstantNode;
    }

    private LookupConstantNode getLookupConstantNode() {
        if (this.lookupConstantNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.lookupConstantNode = (LookupConstantNode)this.insert(LookupConstantNode.create(false, false));
        }
        return this.lookupConstantNode;
    }

    public RubyModule evaluateModule(VirtualFrame frame) {
        return this.checkModule(this.moduleNode.execute(frame));
    }

    public boolean isModuleTriviallyUndefined(VirtualFrame frame, RubyLanguage language, RubyContext context) {
        return this.moduleNode.isDefined(frame, language, context) == nil;
    }

    @Override
    public Object isDefined(VirtualFrame frame, RubyLanguage language, RubyContext context) {
        if (this.isModuleTriviallyUndefined(frame, language, context)) {
            return nil;
        }
        try {
            RubyModule module = this.checkModule(this.moduleNode.execute(frame));
            RubyConstant constant = this.getConstantIfDefined(module);
            return constant == null ? nil : FrozenStrings.CONSTANT;
        }
        catch (RaiseException e) {
            return nil;
        }
    }

    public RubyConstant getConstantIfDefined(RubyModule module) {
        RubyConstant constant;
        try {
            constant = this.getLookupConstantNode().lookupConstant(this, LexicalScope.IGNORE, module, this.name, true);
        }
        catch (RaiseException e) {
            if (e.getException().getLogicalClass() == this.coreLibrary().nameErrorClass) {
                return null;
            }
            throw e;
        }
        if (ModuleOperations.isConstantDefined(constant)) {
            return constant;
        }
        return null;
    }

    public RubyNode makeWriteNode(RubyNode rhs) {
        return new WriteConstantNode(this.name, (RubyNode)NodeUtil.cloneNode((Node)this.moduleNode), rhs);
    }

    private RubyModule checkModule(Object module) {
        if (module instanceof RubyModule) {
            return (RubyModule)module;
        }
        this.notModuleProfile.enter();
        throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorIsNotAClassModule(module, this));
    }

    @Override
    public RubyNode cloneUninitialized() {
        ReadConstantNode copy = new ReadConstantNode(this.moduleNode.cloneUninitialized(), this.name);
        return copy.copyFlags(this);
    }
}

