/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.constants;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.string.FrozenStrings;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.RubyConstant;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.constants.GetConstantNode;
import org.truffleruby.language.constants.LookupConstantWithLexicalScopeNode;
import org.truffleruby.language.constants.LookupConstantWithLexicalScopeNodeGen;
import org.truffleruby.language.control.RaiseException;

public final class ReadConstantWithLexicalScopeNode
extends RubyContextSourceNode {
    private final LexicalScope lexicalScope;
    private final String name;
    @Node.Child
    private LookupConstantWithLexicalScopeNode lookupConstantNode;
    @Node.Child
    private GetConstantNode getConstantNode = GetConstantNode.create();

    public ReadConstantWithLexicalScopeNode(LexicalScope lexicalScope, String name) {
        this.lexicalScope = lexicalScope;
        this.name = name;
        this.lookupConstantNode = LookupConstantWithLexicalScopeNodeGen.create(lexicalScope, name);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        RubyModule module = this.lexicalScope.getLiveModule();
        return this.getConstantNode.lookupAndResolveConstant(this.lexicalScope, module, this.name, this.lookupConstantNode, true);
    }

    @Override
    public Object isDefined(VirtualFrame frame, RubyLanguage language, RubyContext context) {
        RubyConstant constant;
        try {
            constant = this.lookupConstantNode.executeLookupConstant();
        }
        catch (RaiseException e) {
            if (e.getException().getLogicalClass() == this.coreLibrary().nameErrorClass) {
                return nil;
            }
            throw e;
        }
        if (ModuleOperations.isConstantDefined(constant)) {
            return FrozenStrings.CONSTANT;
        }
        return nil;
    }

    @Override
    public RubyNode cloneUninitialized() {
        ReadConstantWithLexicalScopeNode copy = new ReadConstantWithLexicalScopeNode(this.lexicalScope, this.name);
        return copy.copyFlags(this);
    }
}

