/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;

@NodeInfo(cost=NodeCost.NONE)
public final class SequenceNode
extends RubyContextSourceNode {
    @Node.Children
    private final RubyNode[] body;

    public SequenceNode(RubyNode[] body) {
        assert (body.length >= 2) : "sequences must have 2+ elements, but was " + body.length;
        this.body = body;
    }

    @Override
    @ExplodeLoop
    public Object execute(VirtualFrame frame) {
        for (int n = 0; n < this.body.length - 1; ++n) {
            this.body[n].doExecuteVoid(frame);
        }
        return this.body[this.body.length - 1].execute(frame);
    }

    @Override
    @ExplodeLoop
    public void doExecuteVoid(VirtualFrame frame) {
        for (int n = 0; n < this.body.length; ++n) {
            this.body[n].doExecuteVoid(frame);
        }
    }

    public RubyNode[] getSequence() {
        return this.body;
    }

    @Override
    public boolean isContinuable() {
        for (int n = 0; n < this.body.length; ++n) {
            if (this.body[n].isContinuable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public RubyNode simplifyAsTailExpression() {
        if (this.body.length != 0) {
            this.body[this.body.length - 1] = this.body[this.body.length - 1].simplifyAsTailExpression();
        }
        return this;
    }

    @Override
    public RubyNode cloneUninitialized() {
        SequenceNode copy = new SequenceNode(SequenceNode.cloneUninitialized(this.body));
        return copy.copyFlags(this);
    }
}

