/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.control;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RepeatingNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.cast.BooleanCastNode;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.NextException;
import org.truffleruby.language.control.RedoException;
import org.truffleruby.language.control.WhileNodeFactory;

public final class WhileNode
extends RubyContextSourceNode {
    @Node.Child
    private LoopNode loopNode;

    public WhileNode(RepeatingNode repeatingNode) {
        this.loopNode = Truffle.getRuntime().createLoopNode(repeatingNode);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        this.loopNode.execute(frame);
        return nil;
    }

    @Override
    public RubyNode cloneUninitialized() {
        WhileRepeatingBaseNode repeatingNode = (WhileRepeatingBaseNode)this.loopNode.getRepeatingNode();
        WhileNode copy = new WhileNode(repeatingNode.cloneUninitialized());
        return copy.copyFlags(this);
    }

    private static abstract class WhileRepeatingBaseNode
    extends RubyBaseNode
    implements RepeatingNode {
        @Node.Child
        protected RubyNode condition;
        @Node.Child
        protected RubyNode body;

        public WhileRepeatingBaseNode(RubyNode condition, RubyNode body) {
            this.condition = condition;
            this.body = body;
        }

        protected abstract boolean execute(VirtualFrame var1);

        public final boolean executeRepeating(VirtualFrame frame) {
            return this.execute(frame);
        }

        public final Object executeRepeatingWithValue(VirtualFrame frame) {
            if (this.executeRepeating(frame)) {
                return CONTINUE_LOOP_STATUS;
            }
            return BREAK_LOOP_STATUS;
        }

        public String toString() {
            return "while loop at " + RubyLanguage.filenameLine(this.getEncapsulatingSourceSection());
        }

        public abstract WhileRepeatingBaseNode cloneUninitialized();
    }

    public static abstract class DoWhileRepeatingNode
    extends WhileRepeatingBaseNode {
        public DoWhileRepeatingNode(RubyNode condition, RubyNode body) {
            super(condition, body);
        }

        @Specialization
        boolean doRepeating(VirtualFrame frame, @Cached BooleanCastNode booleanCastNode, @Cached InlinedBranchProfile redoUsed, @Cached InlinedBranchProfile nextUsed) {
            try {
                this.body.doExecuteVoid(frame);
            }
            catch (NextException e) {
                nextUsed.enter((Node)this);
            }
            catch (RedoException e) {
                redoUsed.enter((Node)this);
                return true;
            }
            return booleanCastNode.execute(this, this.condition.execute(frame));
        }

        @Override
        public WhileRepeatingBaseNode cloneUninitialized() {
            return WhileNodeFactory.DoWhileRepeatingNodeGen.create(this.condition.cloneUninitialized(), this.body.cloneUninitialized());
        }
    }

    public static abstract class WhileRepeatingNode
    extends WhileRepeatingBaseNode {
        public WhileRepeatingNode(RubyNode condition, RubyNode body) {
            super(condition, body);
        }

        @Specialization
        boolean doRepeating(VirtualFrame frame, @Cached BooleanCastNode booleanCastNode, @Cached InlinedBranchProfile redoUsed, @Cached InlinedBranchProfile nextUsed) {
            boolean conditionAsBoolean = booleanCastNode.execute(this, this.condition.execute(frame));
            if (!conditionAsBoolean) {
                return false;
            }
            while (true) {
                try {
                    this.body.doExecuteVoid(frame);
                    return true;
                }
                catch (NextException e) {
                    nextUsed.enter((Node)this);
                    return true;
                }
                catch (RedoException e) {
                    redoUsed.enter((Node)this);
                    TruffleSafepoint.poll((Node)this);
                    continue;
                }
                break;
            }
        }

        @Override
        public WhileRepeatingBaseNode cloneUninitialized() {
            return WhileNodeFactory.WhileRepeatingNodeGen.create(this.condition.cloneUninitialized(), this.body.cloneUninitialized());
        }
    }
}

