/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.exceptions;

import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.LoopConditionProfile;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.core.cast.BooleanCastNode;
import org.truffleruby.core.cast.SplatCastNode;
import org.truffleruby.core.cast.SplatCastNodeGen;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.exceptions.RescueNode;

public final class RescueSplatNode
extends RescueNode {
    @Node.Child
    private SplatCastNode splatCastNode;
    @Node.Child
    private ArrayStoreLibrary stores;
    private final LoopConditionProfile loopProfile = LoopConditionProfile.create();

    public RescueSplatNode(RubyLanguage language, RubyNode handlingClassesArray, RubyNode rescueBody) {
        super(rescueBody);
        this.splatCastNode = SplatCastNodeGen.create(language, SplatCastNode.NilBehavior.EMPTY_ARRAY, false, handlingClassesArray);
        this.splatCastNode.doNotCopy();
        this.stores = ArrayStoreLibrary.createDispatched(language);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canHandle(VirtualFrame frame, Object exceptionObject, BooleanCastNode booleanCastNode) {
        RubyArray handlingClasses = (RubyArray)this.splatCastNode.execute(frame);
        int i = 0;
        try {
            while (this.loopProfile.inject(i < handlingClasses.size)) {
                if (this.matches(exceptionObject, this.stores.read(handlingClasses.getStore(), i), booleanCastNode)) {
                    boolean bl = true;
                    return bl;
                }
                TruffleSafepoint.poll((Node)this);
                ++i;
            }
        }
        finally {
            this.profileAndReportLoopCount(this.loopProfile, i);
        }
        return false;
    }

    @Override
    public Object isDefined(VirtualFrame frame, RubyLanguage language, RubyContext context) {
        return RubyNode.defaultIsDefined(this);
    }

    @Override
    public RubyNode cloneUninitialized() {
        RescueSplatNode copy = new RescueSplatNode(this.getLanguage(), this.splatCastNode.getChildNode().cloneUninitialized(), this.getRescueBody().cloneUninitialized());
        return copy.copyFlags(this);
    }
}

