/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.exceptions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.truffleruby.core.exception.ExceptionOperations;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.fiber.FiberManager;
import org.truffleruby.core.kernel.AtExitManager;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.backtrace.BacktraceFormatter;
import org.truffleruby.language.control.ExitException;
import org.truffleruby.language.control.KillException;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.objects.IsANode;

public final class TopLevelRaiseHandler
extends RubyBaseNode {
    @CompilerDirectives.TruffleBoundary
    public int execute(Runnable body) {
        int exitCode = 0;
        AbstractTruffleException caughtException = null;
        try {
            body.run();
        }
        catch (ExitException e) {
            return e.getCode();
        }
        catch (AbstractTruffleException e) {
            assert (!(e instanceof KillException)) : e;
            caughtException = e;
            exitCode = this.statusFromException(caughtException);
            this.getLanguage().getCurrentThread().threadLocalGlobals.setLastException(ExceptionOperations.getExceptionObject(caughtException));
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            assert (!(e instanceof FiberManager.FiberShutdownException)) : e;
            BacktraceFormatter.printInternalError(this.getContext(), e, "an internal exception escaped out of the interpreter");
            return 1;
        }
        String step = "unexpected internal exception in at_exit";
        try {
            AbstractTruffleException atExitException = this.getContext().getAtExitManager().runAtExitHooks();
            if (atExitException != null) {
                exitCode = this.statusFromException(atExitException);
            }
            step = "an internal exception escaped out of the interpreter";
            if (caughtException != null) {
                if (!AtExitManager.isSilentException(this.getContext(), caughtException)) {
                    this.getContext().getDefaultBacktraceFormatter().printTopLevelRubyExceptionOnEnvStderr(caughtException);
                }
                this.handleSignalException(caughtException);
            }
        }
        catch (ExitException e) {
            exitCode = e.getCode();
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            BacktraceFormatter.printInternalError(this.getContext(), e, step);
            return 1;
        }
        return exitCode;
    }

    private int statusFromException(AbstractTruffleException exception) {
        InteropLibrary interopLibrary = InteropLibrary.getUncached((Object)((Object)exception));
        try {
            if (interopLibrary.getExceptionType((Object)exception) == ExceptionType.EXIT) {
                return interopLibrary.getExceptionExitStatus((Object)exception);
            }
            return 1;
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    private void handleSignalException(AbstractTruffleException exception) {
        if (exception instanceof RaiseException) {
            RubyException rubyException = ((RaiseException)exception).getException();
            if (IsANode.getUncached().executeIsA(rubyException, this.coreLibrary().signalExceptionClass)) {
                DispatchNode.getUncached().call(rubyException, "reached_top_level");
            }
        }
    }
}

